# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Simulated data for cumulative mileage by four vehicle types over a 38-week period
import numpy as np; np.random.seed(0)
x = np.linspace(1, 38, 38)
y1 = np.cumsum(np.random.poisson(2.3, 38))  # Autonomous Vehicles
y2 = np.cumsum(np.random.poisson(2.1, 38))  # Electric Vehicles
y3 = np.cumsum(np.random.poisson(1.8, 38))  # Hybrid Vehicles
y4 = np.cumsum(np.random.poisson(2.0, 38))  # Public Transport

# Labels and Plot Types
label_Autonomous = "Autonomous Vehicles"
label_Electric = "Electric Vehicles"
label_Hybrid = "Hybrid Vehicles"
label_Public = "Public Transport"

# Axes Limits and Labels
xlabel_value = "Weeks"
ylabel_value = "Cumulative Mileage (Thousand Miles)"
zoomed_in_axes = [0.20, 0.5, 0.25, 0.25]
xlim_values = [33, 38]
ylim_values = [y1[32], max(y1[37], y2[37], y3[37], y4[37]) + 5]
xticks_values = [33, 35, 37]
yticks_values = list(range(int(ylim_values[0]), int(ylim_values[1]) + 5, 5))
title = "Vehicle Mileage Comparison Over 38 Weeks"
# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the main figure and axis
fig, ax = plt.subplots(figsize=(10, 6))

# Plot the curves with distinct styles
ax.plot(x, y1, "r-", label=label_Autonomous)
ax.plot(x, y2, "g--", label=label_Electric)
ax.plot(x, y3, "b-.", label=label_Hybrid)
ax.plot(x, y4, "m:", label=label_Public)

# Set labels and title
ax.set_xlabel(xlabel_value)
ax.set_ylabel(ylabel_value)
ax.set_title(title)

# Create the inset with the zoomed-in view
ax_inset = fig.add_axes(zoomed_in_axes)  # Adjust the position to align with the right side of the main plot
ax_inset.plot(x, y1, "r-")
ax_inset.plot(x, y2, "g--")
ax_inset.plot(x, y3, "b-.")
ax_inset.plot(x, y4, "m:")
ax_inset.set_xlim(xlim_values)
ax_inset.set_ylim(ylim_values)
ax_inset.set_xticks(xticks_values)
ax_inset.set_yticks(yticks_values)
ax_inset.spines["bottom"].set_color("black")  # Add black border to the inset
ax_inset.spines["left"].set_color("black")
ax_inset.spines["top"].set_color("black")
ax_inset.spines["right"].set_color("black")

# Add the legend to the main axis, outside the plot area
ax.legend(loc="lower right")

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig('PIP_18.pdf', bbox_inches='tight')