# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np; np.random.seed(42)
healthcare_facilities = {
    "hospital": np.random.normal(loc=(10, 15), scale=2, size=(50, 2)),  # CityHospital
    "clinic": np.random.normal(loc=(12, 12), scale=2, size=(30, 2)),    # QuickCare
    "urgent_care": np.random.normal(loc=(14, 18), scale=2, size=(40, 2)),  # FastAid
    "specialist_center": np.random.normal(loc=(16, 10), scale=2, size=(60, 2)),  # ExpertHealth
    "lab": np.random.normal(loc=(18, 8), scale=2, size=(70, 2)),  # LabTech
}

# Define colors and markers for each healthcare facility
colors = {
    "hospital": "red",      # CityHospital
    "clinic": "blue",       # QuickCare
    "urgent_care": "green", # FastAid
    "specialist_center": "purple", # ExpertHealth
    "lab": "orange",        # LabTech
}

markers = {
    "hospital": "s",        # CityHospital
    "clinic": "o",          # QuickCare
    "urgent_care": "^",     # FastAid
    "specialist_center": "d", # ExpertHealth
    "lab": "p",             # LabTech
}

# Updated axes limits and ticks for healthcare efficiency context
insetaxes=[0.15, 0.15, 0.2, 0.2]
insetxlim=[10, 14]
insetylim=[10, 14]
insetxticks=[10, 12, 14]
insetyticks=[10, 12, 14]
arrowstart=(11, 6)  # FastAid focus
arrowend=(0.4, 0.3)
annotaterecx = [10, 14]
annotaterecy = [10, 14]
title = "Healthcare Facility Distribution"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the scatter plot
fig, ax = plt.subplots(figsize=(10, 10))

for facility, data in healthcare_facilities.items():
    ax.scatter(data[:, 0], data[:, 1], c=colors[facility], marker=markers[facility], label=facility, alpha=0.7)

# Draw annotation rectangle around specific region   
ax.plot([annotaterecx[0], annotaterecx[1]], [annotaterecy[1], annotaterecy[1]], color="black", lw=1)
ax.plot([annotaterecx[0], annotaterecx[1]], [annotaterecy[0], annotaterecy[0]], color="black", lw=1)
ax.plot([annotaterecx[0], annotaterecx[0]], [annotaterecy[0], annotaterecy[1]], color="black", lw=1)
ax.plot([annotaterecx[1], annotaterecx[1]], [annotaterecy[0], annotaterecy[1]], color="black", lw=1)

# Create the inset with a zoomed-in view of a specific region
ax_inset = fig.add_axes(insetaxes)
for facility, data in healthcare_facilities.items():
    ax_inset.scatter(data[:, 0], data[:, 1], c=colors[facility], marker=markers[facility], alpha=0.7)
ax_inset.set_xlim(insetxlim)
ax_inset.set_ylim(insetylim)
ax_inset.set_xticks(insetxticks)
ax_inset.set_yticks(insetyticks)
ax_inset.spines["bottom"].set_color("black")
ax_inset.spines["left"].set_color("black")
ax_inset.spines["top"].set_color("black")
ax_inset.spines["right"].set_color("black")

# Add annotation to indicate the inset region
ax.annotate("", xy=arrowstart, xytext=arrowend, textcoords="axes fraction", arrowprops=dict(facecolor="black", lw=0.1))

# Add titles and labels
ax.set_title(title)
ax.set_xlabel("Feature X")
ax.set_ylabel("Feature Y")
ax.legend()

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig('PIP_20.pdf', bbox_inches='tight')