# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(42)
# Data representing average literacy rates in different regions over years (in %)
years = np.array([2000, 2005, 2010, 2015, 2020])

region1_rates = np.array([85.2, 88.5, 90.7, 92.0, 93.3]) + np.random.normal(0, 0.3, 5)
region2_rates = np.array([75.4, 78.6, 80.8, 83.2, 85.5]) + np.random.normal(0, 0.3, 5)
region3_rates = np.array([65.1, 68.4, 70.7, 73.0, 75.3]) + np.random.normal(0, 0.3, 5)
region4_rates = np.array([55.5, 57.6, 59.8, 62.1, 64.5]) + np.random.normal(0, 0.3, 5)

# Extracted variables
fill_label_region1 = "Region 1"
fill_label_region2 = "Region 2"
fill_label_region3 = "Region 3"
fill_label_region4 = "Region 4"
title_text = "Average Literacy Rates Over Years"
xlabel_text = "Year"
ylabel_text = "Literacy Rate (%)"
legend_title = "Region"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
xlim_values = (min(years), max(years))
ylim_values = (54.0, 94.0)
xticks_values = years
yticks_values = np.arange(54.0, 94.1, 4.0)
legend_loc = "upper left"
legend_bbox_to_anchor = (1, 1)
legend_ncol = 1
# Create the plot with a different visualization style
plt.figure(figsize=(10, 7))
plt.fill_between(
    years, region1_rates, color="#FF6347", alpha=0.5, label=fill_label_region1
)
plt.fill_between(
    years, region2_rates, color="#4682B4", alpha=0.5, label=fill_label_region2
)
plt.fill_between(
    years, region3_rates, color="#32CD32", alpha=0.5, label=fill_label_region3
)
plt.fill_between(
    years, region4_rates, color="#FFD700", alpha=0.5, label=fill_label_region4
)

# Add a title and labels
plt.title(title_text, fontsize=16, y=1.05)
plt.xlabel(xlabel_text, fontsize=14)
plt.ylabel(ylabel_text, fontsize=14)
plt.xticks(xticks_values, fontsize=12)
plt.yticks(yticks_values, fontsize=12)

# Setting the limits explicitly to prevent cut-offs
plt.xlim(*xlim_values)
plt.ylim(*ylim_values)

# Adding a legend with a title
plt.legend(
    title=legend_title,
    frameon=False,
    loc=legend_loc,
    bbox_to_anchor=legend_bbox_to_anchor,
    ncol=legend_ncol,
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to ensure no clipping
plt.tight_layout()
plt.savefig("area_10.pdf", bbox_inches="tight")