# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(0)
# New Data for Different Domain (Historical Discoveries)
years = ["1800", "1850", "1900", "1950", "2000", "2050"]
discovery_a = np.random.randint(1, 50, size=len(years))
discovery_b = np.random.randint(5, 30, size=len(years))
discovery_c = np.random.randint(10, 60, size=len(years))

# Calculate cumulative values for stacked area chart
cumulative_discovery_a = discovery_a
cumulative_discovery_b = cumulative_discovery_a + discovery_b
cumulative_discovery_c = cumulative_discovery_b + discovery_c

# Positions for the bars on the x-axis
ind = np.arange(len(years))

# Variables for plot configuration
discovery_a_label = "Scientific Discoveries A"
discovery_b_label = "Scientific Discoveries B"
discovery_c_label = "Scientific Discoveries C"
xlabel_text = "Years"
ylabel_text = "Number of Discoveries"
title_text = "Scientific Discoveries Over Time"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
xlim_values = (0, 5)
ylim_values = (0, max(cumulative_discovery_c) + 10)
yticks_values = range(0, max(cumulative_discovery_c) + 10, 20)
legend_location = "upper center"
legend_fontsize = 10
legend_frameon = True
legend_shadow = True
legend_facecolor = "#ffffff"
legend_ncol = 3
legend_bbox_to_anchor = (0.5, 1.15)
figsize = (10, 5)
alpha_value = 0.7
fontsize_xlabel = 14
fontsize_ylabel = 14
fontsize_title = 16
title_y_position = 1.2
grid_linestyle = "--"
grid_alpha = 0.5

# Plot
fig, ax = plt.subplots(figsize=figsize)  # Adjusted for better aspect ratio
ax.fill_between(
    years, 0, cumulative_discovery_a, label=discovery_a_label, color="#42A5F5", alpha=alpha_value
)
ax.fill_between(
    years,
    cumulative_discovery_a,
    cumulative_discovery_b,
    label=discovery_b_label,
    color="#AB47BC",
    alpha=alpha_value,
)
ax.fill_between(
    years,
    cumulative_discovery_b,
    cumulative_discovery_c,
    label=discovery_c_label,
    color="#26A69A",
    alpha=alpha_value,
)

# Enhancing the plot with additional visuals
ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)
ax.spines["left"].set_visible(False)
ax.spines["bottom"].set_visible(False)
ax.set_yticks(yticks_values)
# Setting the x-axis and y-axis limits dynamically
ax.set_ylim(*ylim_values)  # Ensure all data fits well
ax.set_xlim(*xlim_values)
# Labels, Title and Grid
ax.set_xlabel(xlabel_text, fontsize=fontsize_xlabel)
ax.set_ylabel(ylabel_text, fontsize=fontsize_ylabel)
ax.set_title(title_text, fontsize=fontsize_title, y=title_y_position)
ax.tick_params(axis="both", which="both", color="gray")
# Custom legend
ax.legend(
    loc=legend_location,
    fontsize=legend_fontsize,
    frameon=legend_frameon,
    shadow=legend_shadow,
    facecolor=legend_facecolor,
    ncol=legend_ncol,
    bbox_to_anchor=legend_bbox_to_anchor,
)

# Grid
ax.grid(True, linestyle=grid_linestyle, alpha=grid_alpha, which="both")

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to reduce white space
plt.tight_layout()
plt.savefig("area_13.pdf", bbox_inches="tight")