# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(0)
# Data
years = ["2015", "2016", "2017", "2018", "2019", "2020", "2021", "2022"]
research_funding = np.array([1.5, 1.7, 1.8, 2.1, 2.4, 2.6, 2.9, 3.2])
patent_filings = np.array([0.5, 0.6, 0.55, 0.65, 0.75, 0.85, 0.95, 1.1])
publications = np.array([2, 2.1, 2.2, 2.4, 2.5, 2.7, 2.8, 3])

# Calculate cumulative values for stacked area chart
cumulative_research_funding = research_funding
cumulative_patent_filings = cumulative_research_funding + patent_filings
cumulative_publications = cumulative_patent_filings + publications

# Positions for the bars on the x-axis
ind = np.arange(len(years))

# Variables for plot configuration
research_funding_label = "Research Funding"
patent_filings_label = "Patent Filings"
publications_label = "Publications"
xlabel_text = "Year"
ylabel_text = "Cumulative Metrics"
title_text = "Cumulative Research Metrics by Year"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
xlim_values = (0, 7)
ylim_values = (0, 10)
yticks_values = np.arange(0, 11, 1)
legend_location = "upper left"
legend_fontsize = 12
legend_frameon = False
legend_shadow = True
legend_facecolor = "#ffffff"
legend_ncol = 1
legend_bbox_to_anchor = (1.05, 1)
# Plot
fig, ax = plt.subplots(figsize=(10, 6))  # Adjusted for better aspect ratio

ax.fill_between(
    years, 0, cumulative_research_funding, label=research_funding_label, color="#d73027", alpha=0.7
)
ax.fill_between(
    years,
    cumulative_research_funding,
    cumulative_patent_filings,
    label=patent_filings_label,
    color="#fc8d59",
    alpha=0.7,
)
ax.fill_between(
    years,
    cumulative_patent_filings,
    cumulative_publications,
    label=publications_label,
    color="#4575b4",
    alpha=0.7,
)

# Enhancing the plot with additional visuals
ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)
ax.spines["left"].set_visible(False)
ax.spines["bottom"].set_visible(False)

# Setting the x-axis and y-axis limits dynamically
ax.set_ylim(*ylim_values)  # Ensure all data fits well
ax.set_xlim(*xlim_values)

# Labels, Title and Grid
ax.set_xlabel(xlabel_text, fontsize=14)
ax.set_ylabel(ylabel_text, fontsize=14)
ax.set_title(title_text, fontsize=16, y=1.05)
ax.tick_params(axis="both", which="both", color="gray")

# Custom legend
ax.legend(
    loc=legend_location,
    fontsize=legend_fontsize,
    frameon=legend_frameon,
    shadow=legend_shadow,
    facecolor=legend_facecolor,
    ncol=legend_ncol,
    bbox_to_anchor=legend_bbox_to_anchor,
)

# Grid
ax.grid(True, linestyle="--", alpha=0.5, which="both")

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to reduce white space
plt.tight_layout()
plt.savefig("area_14.pdf", bbox_inches="tight")
