# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(1)
months = np.arange(1, 13)
rainfall_data = {
    "Company X": np.random.uniform(1000, 5000, size=12),
    "Company Y": np.random.uniform(800, 4000, size=12),
    "Company Z": np.random.uniform(600, 3000, size=12),
    "Company W": np.random.uniform(400, 2000, size=12),
    "Company V": np.random.uniform(200, 1000, size=12),
}

# Extracted variables
legend_labels = list(rainfall_data.keys())
xlabel_value = "Month"
ylabel_value = "Revenue (USD)"
title_value = "Monthly Revenue of Different Companies"


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
xlim_values = (1, 12)
ylim_values = (0, 16000)
legend_loc = "upper left"
legend_reverse = True
legend_frameon = True
legend_ncol = 1
legend_bbox_to_anchor = (1, 1)
title_y_position = 1.05
colors = ["#ff9999", "#66b3ff", "#99ff99", "#ffcc99", "#c2c2f0"]
fig, ax = plt.subplots(figsize=(12, 8))
ax.stackplot(
    months,
    rainfall_data.values(),
    labels=legend_labels,
    alpha=0.85,
    colors=colors,
)
ax.legend(
    loc=legend_loc,
    reverse=legend_reverse,
    frameon=legend_frameon,
    ncol=legend_ncol,
    bbox_to_anchor=legend_bbox_to_anchor,
)
ax.set_xlim(*xlim_values)
ax.set_ylim(*ylim_values)
ax.set_title(title_value, y=title_y_position)
ax.set_xlabel(xlabel_value)
ax.set_ylabel(ylabel_value)
ax.tick_params(axis="both", which="both", length=0)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("area_17.pdf", bbox_inches="tight")
