# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(0)
year = [1990, 1995, 2000, 2005, 2010, 2015, 2020, 2025]
research_spending_by_institute = {
    "Biochemistry": [1.2, 1.5, 1.8, 2.1, 2.4, 2.7, 3.0, 3.3],
    "Physics": [0.9, 1.1, 1.3, 1.5, 1.7, 1.9, 2.1, 2.3],
    "Computer Science": [0.8, 1.0, 1.3, 1.5, 1.7, 1.9, 2.2, 2.4],
    "Medical": [2.0, 2.3, 2.6, 2.9, 3.2, 3.5, 3.8, 4.1],
    "Engineering": [1.5, 1.7, 1.9, 2.1, 2.3, 2.5, 2.7, 2.9],
}

# Extracted variables
legend_labels = list(research_spending_by_institute.keys())
xlim_values = (1990, 2025)
ylim_values = (0, 16)
xlabel_value = "Year"
ylabel_value = "Research Spending (Billions USD)"
title_value = "Global Research Spending by Institute"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
legend_loc = "upper left"
legend_reverse = False
legend_frameon = True
legend_ncol = 1
legend_bbox_to_anchor = (1, 1)
title_y_position = 1.05
colors = ["#ffb3b3", "#ff9999", "#ff6666", "#ff4d4d", "#ff0000"]

fig, ax = plt.subplots(figsize=(10, 7))
ax.stackplot(
    year,
    research_spending_by_institute.values(),
    labels=legend_labels,
    alpha=0.8,
    colors=colors,
)
ax.legend(
    loc=legend_loc,
    reverse=legend_reverse,
    frameon=legend_frameon,
    ncol=legend_ncol,
    bbox_to_anchor=legend_bbox_to_anchor,
)
ax.set_xlim(*xlim_values)
ax.set_ylim(*ylim_values)
ax.set_title(title_value, y=title_y_position)
ax.set_xlabel(xlabel_value)
ax.set_ylabel(ylabel_value)
ax.tick_params(axis="both", which="both", length=0)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("area_18.pdf", bbox_inches="tight")