# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(4)
categories = np.arange(1, 6, 1)
data = {
    "Region 1": np.random.randint(800, 900, size=(categories.size)),
    "Region 2": np.random.randint(700, 800, size=(categories.size)),
    "Region 3": np.random.randint(600, 700, size=(categories.size)),
    "Region 4": np.random.randint(500, 600, size=(categories.size)),
}

# Extracted variables
legend_labels = list(data.keys())
xlim_values = (1, 5)
ylim_values = (0, 3500)
xlabel_value = "Year"
ylabel_value = "Population (in thousands)"
title_value = "Population Growth Over Years by Region"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
legend_loc = "upper left"
legend_reverse = False
legend_frameon = True
legend_ncol = 1
legend_bbox_to_anchor = (1.1, 1.15)
title_y_position = 1.05
colors = ["#FFD700", "#ADFF2F", "#6495ED", "#DC143C"]

fig, ax = plt.subplots(figsize=(12, 6))
ax.stackplot(
    categories,
    data.values(),
    labels=legend_labels,
    alpha=0.85,
    colors=colors,
)
ax.legend(
    loc=legend_loc,
    reverse=legend_reverse,
    frameon=legend_frameon,
    ncol=legend_ncol,
    bbox_to_anchor=legend_bbox_to_anchor,
)
ax.set_xlim(*xlim_values)
ax.set_ylim(*ylim_values)
ax.set_title(title_value, y=title_y_position, fontsize=18)
ax.set_xlabel(xlabel_value)
ax.set_ylabel(ylabel_value)
ax.grid(True, linestyle='--', color='grey', alpha=0.7)
ax.tick_params(axis="both", which="major", length=5)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("area_19.pdf", bbox_inches="tight")