import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0)

np.random.seed(0)

# ===================
# Part 2: Data Preparation
# ===================
# Data for the plot with new trends
decomposition_IO_norm = np.array([0, 20, 40, 60, 80])
coco_10k = np.array([0.75, 0.70, 0.65, 0.60, 0.55]) + np.array([0.012, -0.003, 0.009, -0.002, 0.01])  # Different trend with small noise
laion_10k = np.array([0.73, 0.68, 0.63, 0.58, 0.53]) + np.array([0.007, -0.002, 0.008, 0.005, -0.003])
coco_5k = np.array([0.72, 0.67, 0.62, 0.57, 0.52])  # Changed last point to non-None
laion_5k = np.array([0.70, 0.65, 0.60, 0.55, 0.50])  # Continuation of the trend
clip = np.linspace(0.55, 0.55, len(decomposition_IO_norm))  # Make clip a downward line

# Extracted variables
fill_label_coco_10k = "natural_images (10k)"
fill_label_laion_10k = "web_images (10k)"
fill_label_coco_5k = "natural_images (5k)"
fill_label_laion_5k = "web_images (5k)"
plot_label_clip = "baseline"
title_text = "Dynamic Effect of Vocab on Zero Shot Accuracy"
xlabel_text = "Decomposition IO Norm"
ylabel_text = "Accuracy"
xlim_values = (min(decomposition_IO_norm), max(decomposition_IO_norm))
ylim_values = (0.45, 0.77)
xticks_values = decomposition_IO_norm
yticks_values = [0.45, 0.50, 0.55, 0.60, 0.65, 0.70, 0.75]
legend_title = "Dataset"
legend_loc = "upper center"
legend_bbox_to_anchor = (0.5, 1.12)
legend_ncol = 5

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot with a different visualization style
plt.figure(figsize=(10, 6))
plt.fill_between(
    decomposition_IO_norm, coco_10k, color="red", alpha=0.3, label=fill_label_coco_10k
)
plt.fill_between(
    decomposition_IO_norm,
    laion_10k,
    color="green",
    alpha=0.3,
    label=fill_label_laion_10k,
)
plt.fill_between(
    decomposition_IO_norm, coco_5k, color="blue", alpha=0.3, label=fill_label_coco_5k
)
plt.fill_between(
    decomposition_IO_norm,
    laion_5k,
    color="orange",
    alpha=0.3,
    label=fill_label_laion_5k,
)
plt.plot(
    decomposition_IO_norm,
    clip,
    color="black",
    linestyle="--",
    linewidth=2,
    label=plot_label_clip,
)

# Add a title and labels with enhanced formatting
plt.title(title_text, fontsize=14, y=1.1)
plt.xlabel(xlabel_text, fontsize=12)
plt.ylabel(ylabel_text, fontsize=12)
plt.xticks(xticks_values)
plt.yticks(yticks_values)
plt.gca().tick_params(axis="both", which="both", length=0)

# Setting the limits explicitly to prevent cut-offs
plt.xlim(*xlim_values)
plt.ylim(*ylim_values)

# Adding a legend with a title
plt.legend(
    title=legend_title,
    frameon=False,
    reverse=True,
    framealpha=0.8,
    loc=legend_loc,
    bbox_to_anchor=legend_bbox_to_anchor,
    ncol=legend_ncol,
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to ensure no clipping
plt.tight_layout()
plt.savefig("area_3.pdf", bbox_inches="tight")
