# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.lines as mlines

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(1)
# Sample data for 12 months
months = np.arange(1, 13)
tech_growth = np.random.uniform(200, 400, size=12)
investment = 1000 + 100 * np.sin(np.pi * months / 6)

# Extracted variables for labels and settings
tech_growth_label = "Tech Growth (Millions $)"
investment_label = "Investment (Millions $)"
legend_labels = ["Tech Growth", "Investment"]
tech_growth_ylabel = "Tech Growth (Millions $)"
investment_ylabel = "Investment (Millions $)"
investment_xlabel = "Month"


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
tech_growth_ylim = [150, 450]
investment_ylim = [800, 1200]
tech_growth_xticks = np.arange(1, 13, 1)
investment_xlim = [1, 12]
investment_xticks = np.arange(1, 13, 1)
investment_yticks = np.arange(800, 1301, 100)
legend_loc = "lower center"
legend_bbox_to_anchor = (0.5, -0.2)
legend_ncol = 2
legend_frameon = False
# Create figure and axes
fig, (ax1, ax2) = plt.subplots(2, 1, figsize=(12, 12))

# Plot Tech Growth
ax1.plot(months, tech_growth, "o--", color="#89CFF0", label=tech_growth_label)
ax1.set_ylim(tech_growth_ylim)
ax1.set_xlim(investment_xlim)
ax1.set_xticks(tech_growth_xticks)
ax1.set_ylabel(tech_growth_ylabel)
ax1.tick_params(axis="both", which="both", length=0)
ax1.grid(True)

# Plot Investment
ax2.plot(months, investment, "s-", color="#D62728", label=investment_label)
ax2.set_ylim(investment_ylim)
ax2.set_xlim(investment_xlim)
ax2.set_yticks(investment_yticks)
ax2.set_xticks(investment_xticks)
ax2.set_xlabel(investment_xlabel)
ax2.set_ylabel(investment_ylabel)
ax2.tick_params(axis="both", which="both", length=0)
ax2.grid(True)

# Create custom legend
blue_dot = mlines.Line2D(
    [], [], color="#89CFF0", marker="o", markersize=8, label=legend_labels[0], linestyle='None'
)
red_square = mlines.Line2D(
    [], [], color="#D62728", marker="s", markersize=8, label=legend_labels[1]
)
plt.legend(
    handles=[blue_dot, red_square],
    loc=legend_loc,
    bbox_to_anchor=legend_bbox_to_anchor,
    ncol=legend_ncol,
    frameon=legend_frameon,
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("area_9.pdf", bbox_inches="tight")