
import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)

# ===================
# Part 2: Data Preparation
# ===================
# Data
categories = ["Electrodynamics", "Quantum Mechanics", "Thermodynamics", "Fluid Dynamics", "Acoustics", "Astrophysics"]
rbf_int = [2e-2, 5e-3, 2e-2, 3e-2, 4e-3, 2e-2] 
rbf_pol = [3e-2, 6e-4, 2e-2, 3e-2, 5e-3, 3e-2] 
rbf_com = [4e-2, 7e-3, 2e-2, 4e-2, 3e-3, 4e-2]

x = np.arange(len(categories))  # the label locations
width = 0.25  # the width of the bars

# Labels for legend
label_rbf_int = "Finite Element"
label_rbf_pol = "Spectral Method"
label_rbf_com = "Finite Difference"

# Axis labels
xlabel = "Fields"
ylabel = "log L2 Error"

# Axis ticks
xticks = x
yticks = [1e-4, 1e-3, 1e-2, 1e-1]

# Axis tick labels
xticklabels = categories
yticklabels = ["1e-4", "1e-3", "1e-2", "1e-1"]
# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(10, 6))
rects1 = ax.bar(x - width, rbf_int, width, label=label_rbf_int, color="#3c0f64")
rects2 = ax.bar(x, rbf_pol, width, label=label_rbf_pol, color="#ae4256")
rects3 = ax.bar(x + width, rbf_com, width, label=label_rbf_com, color="#e47f37")

ax.set_ylabel(ylabel)
ax.set_yscale("log")
ax.set_xlabel(xlabel)
ax.set_xticks(xticks)
ax.set_xticklabels(xticklabels)

# Set custom y-ticks on the log scale and their labels
ax.set_yticks(yticks)
ax.set_yticklabels(yticklabels)

ax.legend(ncol=3, loc="upper center", bbox_to_anchor=(0.5, 1.1), frameon=False)

ax.tick_params(axis="both", which="both", length=0)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig('bar_29.pdf', bbox_inches='tight')
