import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)

# ===================
# Part 2: Data Preparation
# ===================
# Data
labels = [
    "Math",
    "Science",
    "History",
    "English",
    "Art",
    "PE",
    "Music",
    "Geography",
    "Math",
    "Science",
    "History",
    "Math",
    "Science",
    "History",
]
excelling = [55, 48, 0, 0, 0, 70, 65, 60, 0, 0, 0, 0, 0, 0]
needing_improvement = [
    0,
    0,
    30,
    35,
    28,
    0,
    0,
    0,
    40,
    60,
    50,
    45,
    55,
    42,
]

x = np.arange(len(labels))  # the label locations
width = 0.7  # the width of the bars

line_y_1 = 25
line_y_2 = 55
line_x_1 = 4.5
line_x_2 = 10.5

# Labels and Plot Types
label_Excelling = "Excelling"
label_Needing_Improvement = "Needing Improvement"
legend_title = "Student Performance"

# Axes Limits and Labels
ylabel_value = "Percentage (%)"
title_value = "Student Performance in Various Subjects"
ylim_values = [0, 80]
xlim_values = [-0.6, 14]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
fig, ax = plt.subplots(
    figsize=(10, 5)
)  # Adjust the size to match the original image's dimensions
rects1 = ax.bar(x, excelling, width, label=label_Excelling, color="#81b4a2")
rects2 = ax.bar(x, needing_improvement, width, label=label_Needing_Improvement, color="#dd997b")

# Add some text for labels, title and custom x-axis tick labels, etc.
ax.set_ylabel(ylabel_value)
ax.set_title(title_value)
ax.set_xticks(x)
ax.set_xticklabels(labels, rotation=45, ha="center")
ax.set_ylim(ylim_values)
ax.set_xlim(xlim_values)

# Adding the values on top of the bars
for rect in rects1:
    if rect.get_height() > 0:
        height = rect.get_height()
        ax.annotate(
            "{}".format(height),
            xy=(rect.get_x() + rect.get_width() / 2, height),
            xytext=(0, 3),  # 3 points vertical offset
            textcoords="offset points",
            ha="center",
            va="bottom",
        )
for rect in rects2:
    if rect.get_height() > 0:
        height = rect.get_height()
        ax.annotate(
            "{}".format(height),
            xy=(rect.get_x() + rect.get_width() / 2, height),
            xytext=(0, 3),  # 3 points vertical offset
            textcoords="offset points",
            ha="center",
            va="bottom",
        )

# Reference lines
ax.axhline(y=line_y_1, color="red", linestyle="--")
ax.axhline(y=line_y_2, color="gray", linestyle="--")
ax.axvline(x=line_x_1, color="gray", linestyle="--")
ax.axvline(x=line_x_2, color="gray", linestyle="--")

# Hide the ticks
ax.tick_params(axis="both", which="both", length=0)

# Hide the right and top spines
ax.spines["right"].set_visible(False)
ax.spines["top"].set_visible(False)
ax.legend(title=legend_title)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig('bar_4.pdf', bbox_inches='tight')
