import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Data
categories = [
    "Blog Posts",
    "Photo Uploads",
    "Video Uploads",
    "Live Streams",
    "Online Purchases",
    "Product Reviews",
    "Forum Posts",
    "Event Registrations",
    "Webinar Attendance",
    "Podcast Subscriptions",
    "E-Book Downloads",
    "Online Courses",
    "Virtual Meetings",
    "Social Media Posts",
    "Newsletter Signups",
    "Online Surveys",
    "Virtual Conferences",
    "Online Donations",
]

differences = [
    7,
    -12,
    -18,
    -11,
    15,
    22,
    -32,
    -28,
    -38,
    58,
    -68,
    -78,
    82,
    105,
    125,
    155,
    162,
    175,
]

colors = ["#d1605e" if x < 0 else "#85b6b2" for x in differences]

title = "Relative Difference in User Engagement Across Online Activities"
xlabel = "Difference (%)"
ylabel = "Activity Type"
xlim = [-80, 200]
xticks = range(-80, 201, 50)

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and plot
fig, ax = plt.subplots(figsize=(10, 5))
ax.barh(categories, differences, color=colors)

# Set title and labels
ax.set_title(title)
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)

# Set x-axis limits and labels
ax.set_xlim(xlim)
ax.set_xticks(xticks)
ax.xaxis.grid(True)

# ===================
# Part 4: Saving Output
# ===================
# Save the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig('bar_40.pdf', bbox_inches='tight')
