import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Data
professions = [
    "Software Developer",
    "Data Scientist",
    "Graphic Designer",
    "Marketing Manager",
    "Teacher",
    "Nurse",
    "Civil Engineer",
    "Chef",
    "Electrician",
    "Plumber",
]
number_of_videos = [1850, 2100, 1950, 2250, 2400, 2600, 2300, 2500, 2050, 2200]

# Axes Limits and Labels
xlabel_value = "Number of Videos"
title = "Number of Videos by Profession"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create horizontal bar chart
plt.figure(figsize=(12, 8))  # Adjust figure size to match original image's dimensions
plt.barh(professions, number_of_videos, color="#685bc6")  # Change bar color to purple
plt.xlabel(xlabel_value)
plt.title(title)

# Add data labels
for index, value in enumerate(number_of_videos):
    plt.text(
        value + 50, index, str(value), va="center", fontsize=10
    )  # Adjust text position and font size

# Rotate y-axis labels if needed
plt.yticks(rotation=0)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig('bar_51.pdf', bbox_inches='tight')
