import numpy as np; np.random.seed(0); np.random.seed(0)

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Economic data for household income metrics
regions = ["North", "South", "East", "West"]
median_income=[42,60.77,36.8,43.7]
poverty_rate=[13.5,16.0,11.0,9.78]
unemployment_rate=[5.5,7.0,5.0,6.0]
housing_costs=[26,36,14,21]
labels = ["Median Income (USD)", "Poverty Rate (%)", "Unemployment Rate (%)", "Housing Costs (USD/month)"]
xlabel = "Metrics"
ylabel = "Region"
title = "Household Income Metrics by Region"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Size of the plot
plt.figure(figsize=(10, 7))

# Adjust the position of the bars on the x-axis to prevent overlap
bar_height = 0.3
indices = np.arange(len(median_income)) * 1.5  # Increase space between groups

# Define some hatch patterns and colors to use for bars
hatch_patterns = ["/", "\\", "|", "-", "+", "*"]
colors = ["#66c4d5", "#eca198", "#5886c7", "#a791e8"]

# Plot bars for each air quality metric
for i, level in enumerate([median_income, poverty_rate, unemployment_rate, housing_costs]):
    bars = plt.barh(
        [pos + bar_height * i for pos in indices],
        level,
        color=colors[i],
        height=bar_height,
        hatch=hatch_patterns[i],
        label=f'{labels[i]}',
    )

    # Add text annotations to the right of the bars
    for bar in bars:
        plt.text(
            bar.get_width(),  # X position
            bar.get_y() + bar.get_height() / 2,  # Y position
            f"{bar.get_width():.2f}",  # Text to display
            va="center",
        )

# X and Y axis Labels and limits
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.xlim(
    0,
    max(np.max(median_income), np.max(poverty_rate), np.max(unemployment_rate), np.max(housing_costs))
    + 10,
)

# Title of the plot
plt.title(title)

# Adding legend
plt.legend()

# Setting the labels for y-axis with adjusted positions
plt.yticks([pos + bar_height * 1.5 for pos in indices], regions)

# Adding grids
plt.grid(True, linestyle="--", which="both", axis="x", color="grey", alpha=0.7)

# ===================
# Part 4: Saving Output
# ===================
# Display the plot with enough space
plt.tight_layout()

# Save the plot as a PDF file
plt.savefig('bar_64.pdf', bbox_inches='tight')
