import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
health_indicators = ["Life Expectancy", "Infant Mortality Rate", "Obesity Rate", "Access to Clean Water", "Healthcare Expenditure"]
values = [72.6, 3.2, 23.1, 92.8, 9.8]  # Example values (Life Expectancy in years, Infant Mortality Rate per 1000 births, Obesity Rate in percentage, Access to Clean Water in percentage, Healthcare Expenditure in percentage of GDP)
xlabel = "Health Indicator"
ylabel = "Value"
title = "Key Health Indicators Across Countries"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(8, 4))
plt.bar(health_indicators, values, color="skyblue", edgecolor="black")
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig('bar_77.pdf', bbox_inches='tight')
