import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Sample data for the boxplots representing average fuel efficiency (mpg) for different vehicle categories
data = [
    [24, 25, 26, 27, 28],
    [22, 23, 24, 25, 26],
    [18, 19, 20, 21, 22],
    [20, 21, 22, 23, 24],
    [15, 16, 17, 18, 19],
]

# Vehicle categories for the x-axis
categories = [
    "Sedans",
    "SUVs",
    "Trucks",
    "Hybrids",
    "Electric",
]

# Axes Limits and Labels
xticks_values = range(1, len(categories) + 1)
ylim_values = [14, 30]
yticks_values = [15, 18, 21, 24, 27, 30]
yticks_label = ["15", "18", "21", "24", "27", "30"]
ylabel_value = "Fuel Efficiency (mpg)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the boxplot
plt.figure(figsize=(8, 6))  # Size in inches (converted from provided dimensions)
plt.boxplot(data, medianprops=dict(color="orange"))

# Set the x-axis labels
plt.xticks(xticks_values, categories)
plt.ylim(ylim_values)
plt.yticks(
    yticks_values,
    yticks_label,
)
# Set the y-axis label
plt.ylabel(ylabel_value)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig('box_12.pdf', bbox_inches='tight')
