import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)

# ===================
# Part 2: Data Preparation
# ===================
# Sample data for demonstration purposes
comfort_data = [np.array([8.38, 7.7, 7.99, 8.62, 8.43, 7.01, 7.98, 7.42, 7.45, 7.71]),
                np.array([7.38, 6.7, 6.99, 7.62, 7.43, 6.01, 6.98, 6.42, 6.45, 6.71])]
efficiency_data = [np.array([8.71, 8.16, 8.39, 8.9, 8.75, 7.61, 8.38, 7.94, 7.96, 8.16]), 
                   np.array([7.71, 7.16, 7.39, 7.9, 7.75, 6.61, 7.38, 6.94, 6.96, 7.16])]

title_1 = "Comfort"
title_2 = "Efficiency"
xticklabels = ["Car", "Bicycle"]
# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size to match the original image's dimensions
plt.figure(figsize=(8, 6))

# Create subplots
fig, axs = plt.subplots(2, 2)

# Plot the boxplots
bp1 = axs[0, 0].boxplot(
    comfort_data,
    patch_artist=True,
    widths=0.5,
    showfliers=False,
    medianprops=dict(color="black"),
)
bp2 = axs[0, 1].boxplot(
    efficiency_data,
    patch_artist=True,
    widths=0.5,
    showfliers=False,
    medianprops=dict(color="black"),
)
bp3 = axs[1, 0].boxplot(
    comfort_data,
    patch_artist=True,
    widths=0.5,
    showfliers=False,
    medianprops=dict(color="black"),
)
bp4 = axs[1, 1].boxplot(
    efficiency_data,
    patch_artist=True,
    widths=0.5,
    showfliers=False,
    medianprops=dict(color="black"),
)

# Set the colors of the boxes
bp1["boxes"][0].set_facecolor("#d98694")
bp1["boxes"][1].set_facecolor("#5d9c97")
bp2["boxes"][0].set_facecolor("#d98694")
bp2["boxes"][1].set_facecolor("#5d9c97")
bp3["boxes"][0].set_facecolor("#d98694")
bp3["boxes"][1].set_facecolor("#5d9c97")
bp4["boxes"][0].set_facecolor("#d98694")
bp4["boxes"][1].set_facecolor("#5d9c97")

# Set titles and labels
axs[0, 0].set_title(title_1)
axs[0, 0].grid(True)
axs[0, 1].set_title(title_2)
axs[0, 1].grid(True)
axs[0, 0].set_xticklabels(xticklabels)
axs[0, 1].set_xticklabels(xticklabels)
axs[1, 0].set_title(title_1)
axs[1, 0].grid(True)
axs[1, 1].set_title(title_2)
axs[1, 1].grid(True)
axs[1, 0].set_xticklabels(xticklabels)
axs[1, 1].set_xticklabels(xticklabels)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig('box_2.pdf', bbox_inches='tight')
