# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Create a new set of grid for different variables
import numpy as np
np.random.seed(42)
x = np.linspace(0, 10, 100)
y = np.linspace(0, 10, 100)
X, Y = np.meshgrid(x, y)

# Define a new function with multiple sine waves
def volcano_pattern(X, Y):
    return np.sin(X) + np.cos(Y) + 0.3 * np.sin(3 * X) + 0.3 * np.cos(3 * Y)

# Calculate values on the grid
Z_values = volcano_pattern(X, Y)

# Extracted variables
xlabel = 'Longitude'
ylabel = 'Latitude'
title = 'Volcano Activity Heatmap'
colorbar_label = 'Activity Level'

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the contour plot
plt.figure(figsize=(10, 8))

# Using a distinct colormap with "coolwarm"
n_levels = 15  # Number of contour levels
cmap = plt.cm.coolwarm

contour = plt.contourf(X, Y, Z_values, levels=n_levels, cmap=cmap)
plt.contour(X, Y, Z_values, levels=n_levels, colors='k', linewidths=0.5)

# Add a color bar
cbar = plt.colorbar(contour)
cbar.set_label(colorbar_label)

# Label the axes
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()

# Show the plot
plt.savefig("contour_12.pdf", bbox_inches="tight")