# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(0)
# Sample data to create another type of distribution contour lines
x = np.linspace(-10, 10, 150)
y = np.linspace(-10, 10, 150)
X, Y = np.meshgrid(x, y)
Z1 = np.exp(-(X**2 + Y**2) / 25) * np.cos(X) * np.sin(Y)
Z2 = -np.exp(-(X**2 + Y**2) / 25) * np.sin(X) * np.cos(Y)

# Labels and texts
labels = ["Technology A", "Technology B"]
xlabel = "Time (Years)"
ylabel = "Advancements Level"
title = "Technology Advancement Contours"
cbar_label = "Advancement Intensity"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
fig, ax = plt.subplots(figsize=(12, 9))

legend_fontsize = 13
xlabel_fontsize = 15
ylabel_fontsize = 15
title_fontsize = 18
cbar_fontsize = 13

# Contour lines for Technology A (cool colors) and Technology B (warm colors)
CS1 = ax.contour(X, Y, Z1, colors="green", linestyles='dotted', linewidths=1)
CS2 = ax.contour(X, Y, Z2, colors="red", linestyles='dashdot', linewidths=2)

# Labels for x and y axes
ax.set_xlabel(xlabel, fontsize=xlabel_fontsize)
ax.set_ylabel(ylabel, fontsize=ylabel_fontsize)
ax.set_title(title, fontsize=title_fontsize)

# Adding a legend manually
h1, _ = CS1.legend_elements()
h2, _ = CS2.legend_elements()
ax.legend([h1[0], h2[0]], labels, fontsize=legend_fontsize)

# Set the aspect of the plot
ax.set_aspect("equal")
ax.grid(True)
ax.set_facecolor("#e0e0e0")
ax.set_ylim(-10, 10)
ax.set_xlim(-10, 10)

# Add color bar to represent field intensity
field_intensity = ax.contourf(X, Y, Z1 + Z2, alpha=0.3, cmap='viridis')
cbar = fig.colorbar(field_intensity, ax=ax)
cbar.set_label(cbar_label, fontsize=cbar_fontsize)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("contour_15.pdf", bbox_inches="tight")