# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data: Simulate population density over a geographical area
np.random.seed(2)
X, Y = np.meshgrid(np.linspace(-3, 3, 300), np.linspace(-3, 3, 300))

# Simulate varying population density distribution
Z1 = np.sin(np.pi * X / 2) * np.cos(np.pi * Y / 2)
Z2 = np.exp(-(X ** 2 + Y ** 2) / 3)
Z = Z1 + Z2

# Extracted strings
title_text = "Population Density Distribution"
xlabel_text = "Longitude"
ylabel_text = "Latitude"
colorbar_label_text = "Population Density"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Filled contour with custom colormap
fig, ax = plt.subplots(figsize=(8, 6))
clabel_fmt = "%.2f"
cnt = ax.contour(X, Y, Z, levels=15, colors="black", linewidths=0.8)
ax.clabel(cnt, cnt.levels, inline=True, fontsize=8, fmt=clabel_fmt)
contour_filled = ax.contourf(X, Y, Z, levels=15, cmap="viridis")

# Title and Labels
ax.set_title(title_text)
ax.set_xlabel(xlabel_text)
ax.set_ylabel(ylabel_text)
cbar = fig.colorbar(contour_filled, ax=ax)
cbar.set_label(colorbar_label_text)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("contour_18.pdf", bbox_inches="tight")