# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(42)
# Sample data to create contour lines for clinical trial metrics
x = np.linspace(0, 100, 150)
y = np.linspace(0, 50, 150)
X, Y = np.meshgrid(x, y)
Z1 = np.exp(-((X - 50)**2 + (Y - 25)**2) / 200)
Z2 = np.exp(-((X - 75)**2 + (Y - 10)**2) / 200)

# Labels and texts
labels = ["Drug A", "Drug B"]
xlabel = "Dosage (mg)"
ylabel = "Effectiveness (%)"
title = "Clinical Trial Metrics"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
fig, ax = plt.subplots(figsize=(12, 10))

legend_loc = 'upper left'
fontsize_label = 12
fontsize_title = 16
fontsize_legend = 10
fontweight_label = 'bold'
fontweight_title = 'bold'

# Contour lines for Drug A (blue) and Drug B (red)
CS1 = ax.contour(X, Y, Z1, colors="blue", linestyles='-', linewidths=1.5, label=labels[0])
CS2 = ax.contour(X, Y, Z2, colors="red", linestyles='--', linewidths=1.5, label=labels[1])

# Labels for x and y axes
plt.xlabel(xlabel, fontsize=fontsize_label, fontweight=fontweight_label)
plt.ylabel(ylabel, fontsize=fontsize_label, fontweight=fontweight_label)

# Adding a legend manually
h1, _ = CS1.legend_elements()
h2, _ = CS2.legend_elements()
ax.legend([h1[0], h2[0]], labels, loc=legend_loc, fontsize=fontsize_legend)

# Set the aspect of the plot to match the original image
ax.set_aspect("auto")
ax.grid(True)
ax.set_facecolor("#e0e0e0")  # Light gray background
ax.set_xlim(0, 100)
ax.set_ylim(0, 50)

# Title of the plot
plt.title(title, fontsize=fontsize_title, fontweight=fontweight_title)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("contour_20.pdf", bbox_inches="tight")