# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from matplotlib.patches import Patch

# ===================
# Part 2: Data Preparation
# ===================
# Simulated data generation for height and weight
import numpy as np
np.random.seed(0)
height = np.linspace(140, 210, 400)
weight = np.linspace(40, 150, 400)
HEIGHT, WEIGHT = np.meshgrid(height, weight)
pos = np.dstack((HEIGHT, WEIGHT))

# Simulate Gaussian distributions for height and weight
def gaussian(x, y, mean, cov):
    return np.exp(-((x-mean[0])**2/(2*cov[0][0]) + (y-mean[1])**2/(2*cov[1][1])))

Z_height = gaussian(HEIGHT, WEIGHT, [175, 80], [[75, 0], [0, 200]])
Z_weight = gaussian(HEIGHT, WEIGHT, [160, 100], [[60, 0], [0, 150]])

# Extracted variables
title = "Distribution of Height and Weight Levels"
labels = ["Height", "Weight"]
xlabel = "Height (cm)"
ylabel = "Weight (kg)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
plt.figure(figsize=(10, 6))

# Contour plots for the distributions
contour_height = plt.contourf(HEIGHT, WEIGHT, Z_height, cmap="Blues", alpha=0.6)
contour_weight = plt.contourf(HEIGHT, WEIGHT, Z_weight, cmap="Oranges", alpha=0.6)
plt.title(title)

# Create legend with color patches
legend_patches = [
    Patch(color="blue", label=labels[0]),
    Patch(color="orange", label=labels[1]),
]
plt.legend(handles=legend_patches)

# Axis labels
plt.xlabel(xlabel)
plt.ylabel(ylabel)

# Adjust plot to be visually appealing
plt.gca().set_aspect("equal", adjustable="box")

# ===================
# Part 4: Saving Output
# ===================
# Reduce whitespace around the plot
plt.tight_layout()
plt.savefig("contour_7.pdf", bbox_inches="tight")