# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt
from matplotlib.patches import Patch

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Sample data generation for Gaussian Peaks
x = np.linspace(-100, 100, 500)
y = np.linspace(-100, 100, 500)
X, Y = np.meshgrid(x, y)

# Define Gaussian Functions for data representation
def gaussian(x, y, x0, y0, sx, sy):
    return np.exp(-(((x - x0) ** 2) / (2 * sx ** 2) + ((y - y0) ** 2) / (2 * sy ** 2)))

# Generate data
Z1 = gaussian(X, Y, 30, -30, 20, 30)
Z2 = gaussian(X, Y, -50, 50, 40, 20)
Z3 = gaussian(X, Y, 0, 0, 60, 60)

# Chart titles and labels
title = "Gaussian Peaks in Climate Data"
xlabel = "X-axis"
ylabel = "Y-axis"
labels = ["Temperature Anomaly A", "Temperature Anomaly B", "Temperature Anomaly C"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
plt.figure(figsize=(12, 8))
contour1 = plt.contourf(X, Y, Z1, cmap="Blues", alpha=0.6)
contour2 = plt.contourf(X, Y, Z2, cmap="Reds", alpha=0.4)
contour3 = plt.contourf(X, Y, Z3, cmap="Purples", alpha=0.3)

# Title and labels
plt.title(title, fontsize=16)
plt.xlabel(xlabel, fontsize=14)
plt.ylabel(ylabel, fontsize=14)

# Create legend with color patches
legend_patches = [
    Patch(color="blue", label=labels[0]),
    Patch(color="red", label=labels[1]),
    Patch(color="purple", label=labels[2]),
]
plt.legend(handles=legend_patches, fontsize=12)

# Additional plot adjustments
plt.gca().set_aspect("equal", adjustable="box")
plt.grid(True)

# ===================
# Part 4: Saving Output
# ===================
# Reduce whitespace around the plot
plt.tight_layout()
plt.savefig("contour_9.pdf", bbox_inches="tight")