# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from scipy.stats import gaussian_kde

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(42)
# Sample data for human body temperature under different conditions
normal_temperature = np.random.normal(loc=37.0, scale=0.5, size=1500)
feverish_condition = np.random.normal(loc=38.5, scale=0.4, size=1500)
hypothermic_condition = np.random.normal(loc=35.5, scale=0.6, size=1500)
labels = ["Normal Temperature", "Feverish Condition", "Hypothermic Condition"]
avxlabel = "Clinical Threshold"
xlabel = "Body Temperature (Celsius)"
ylabel = "Density"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the figure and axis
fig, ax = plt.subplots(figsize=(9, 6))

# Plot the density plots
for data, color, label in zip(
    [normal_temperature, feverish_condition, hypothermic_condition],
    ["#2ca02c", "#1f77b4", "#9467bd"],  # Using a set of visually appealing colors
    labels,
):
    density = gaussian_kde(data)
    xs = np.linspace(34.0, 40.0, 200)
    density.covariance_factor = lambda: 0.5
    density._compute_covariance()
    plt.fill_between(xs, density(xs), color=color, alpha=0.3, label=label)

# Plot the clinical threshold line
plt.axvline(x=37.5, color="orange", linestyle="--", label=avxlabel)

# Set labels and title (if any)
ax.set_xlim(34.0, 41.0)
ax.set_xticks([34.0, 35.0, 36.0, 37.0, 38.0, 39.0, 40.0])
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)

# Show grid
plt.grid(True, linestyle="--")

# Add legend
plt.legend()

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("density_18.pdf", bbox_inches="tight")
