# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from scipy.stats import gaussian_kde

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(43)
# Sample data for a different topic (e.g., tech innovation ratings)
smartphone_ratings = np.random.normal(loc=7, scale=1, size=1000)
laptop_ratings = np.random.normal(loc=8.5, scale=1, size=1000)

# Compute density for each dataset
density_phone = gaussian_kde(smartphone_ratings)
density_laptop = gaussian_kde(laptop_ratings)
xs = np.linspace(3, 12, 300)
ys_phone = density_phone(xs)
ys_laptop = density_laptop(xs)

# Labels and texts
labels = ["Smartphones", "Laptops"]
xlabel = "Rating"
ylabel = "Density"
title = "Distribution of Tech Innovation Ratings for Smartphones and Laptops"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the figure and axis
fig, ax = plt.subplots(figsize=(10, 7))

xlim = (3, 12)
grid_style = ":"

# Fill between x for density regions
plt.fill_between(xs, ys_phone, color="green", alpha=0.3, label=labels[0])
plt.fill_between(xs, ys_laptop, color="red", alpha=0.3, label=labels[1])

# Set labels and title (if any)
ax.set_xlim(xlim)
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)

# Show grid
plt.grid(True, linestyle=grid_style)

# Add legend
plt.legend()

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("density_19.pdf", bbox_inches="tight")