import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)

from scipy.stats import gaussian_kde

# ===================
# Part 2: Data Preparation
# ===================
# Generate a bimodal distribution for test scores
scores_group1 = np.array([34.47, 66.54, 68.64, 52.58, 82.70, 45.46, 60.46, 58.13, 75.33, 74.69]) 
scores_group2 = np.array([81.55, 83.78, 71.12, 60.19, 76.52, 81.56, 92.30, 92.02, 76.13, 76.98])  
test_scores = np.concatenate([scores_group1, scores_group2])
score_range = np.linspace(30, 110, 200)

# Axes Limits and Labels
xticks_values = [40, 50, 60, 70, 80, 90, 100]
xticklabels = ["40", "50", "60", "70", "80", "90", "100"]
yticks_values = [0, 0.01, 0.02, 0.03, 0.04]
yticklabels = ["0.00", "0.01", "0.02", "0.03", "0.04"]
xlim_values = [30, 110]
ylim_values = [0, 0.04]
title = "KDE Plot of Student Test Scores Distribution"
xlabel_value = "Test Score"
ylabel_value = "Density"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size to match the original image's dimensions
fig, ax = plt.subplots(figsize=(8, 4))

# Create the KDE plot with adjusted x-axis range
density = gaussian_kde(test_scores)
density.covariance_factor = lambda: 0.5
density._compute_covariance()
plt.fill_between(score_range, density(score_range), color="#d1e4e5", edgecolor="teal")

ax.set_xticks(xticks_values)
ax.set_xticklabels(xticklabels)

ax.set_yticks(yticks_values)
ax.set_yticklabels(yticklabels)

plt.xlim(xlim_values)
plt.ylim(ylim_values)
# Set the title and labels
plt.title(title)
plt.xlabel(xlabel_value)
plt.ylabel(ylabel_value)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig('density_3.pdf', bbox_inches='tight')
