import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)

from scipy.stats import gaussian_kde

# ===================
# Part 2: Data Preparation
# ===================
# Sample data for energy consumption strategies
solar_energy = np.random.normal(loc=50, scale=10, size=1000)
wind_energy = np.random.normal(loc=40, scale=8, size=1000)
hydro_energy = np.random.normal(loc=45, scale=6, size=1000)
labels = ["Solar Energy", "Wind Energy", "Hydro Energy"]
threshold_label = "Energy Consumption Threshold"
xlabel = "Energy Consumption (kWh)"
ylabel = "Density"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the figure and axis
fig, ax = plt.subplots(figsize=(9, 6))

# Plot the density plots
for data, color, label in zip(
    [solar_energy, wind_energy, hydro_energy],
    ["blue", "red", "green"],
    labels,
):
    density = gaussian_kde(data)
    xs = np.linspace(10, 80, 200)
    density.covariance_factor = lambda: 0.5
    density._compute_covariance()
    plt.fill_between(xs, density(xs), color=color, alpha=0.2, label=label)

# Plot the energy consumption threshold line
plt.axvline(x=55, color="red", linestyle="--", label=threshold_label)

# Set labels and title (if any)
ax.set_xlim(10, 80)
ax.set_xticks([10, 20, 30, 40, 50, 60, 70, 80])
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)

# Show grid
plt.grid(True, linestyle="--")

# Add legend
plt.legend()

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig('density_4.pdf', bbox_inches='tight')
