import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)

from scipy.stats import gaussian_kde

# ===================
# Part 2: Data Preparation
# ===================
# Sample data for transportation domain
car_speeds = np.random.normal(loc=100, scale=15, size=1000)  # Car speeds on highways (km/h)
train_speeds = np.random.normal(loc=150, scale=20, size=1000)  # Train speeds on railways (km/h)

# Compute density for each dataset
density_car = gaussian_kde(car_speeds)
density_train = gaussian_kde(train_speeds)
xs = np.linspace(50, 200, 300)
ys_car = density_car(xs)
ys_train = density_train(xs)
labels = ["Car Speeds", "Train Speeds"]
xlabel = "Density"
ylabel = "Speed (km/h)"
# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the figure and axis
fig, ax = plt.subplots(figsize=(9, 6))

# Fill between x for density regions
plt.fill_betweenx(xs, ys_car, color="blue", alpha=0.2, label=labels[0])
plt.fill_betweenx(xs, ys_train, color="green", alpha=0.2, label=labels[1])

# Set labels and title (if any)
ax.set_ylim(50, 200)
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)

# Show grid
plt.grid(True, linestyle="--")

# Add legend
plt.legend()

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig('density_5.pdf', bbox_inches='tight')
