# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(2)
# Generate data for the plot
x = np.linspace(0, 10, 100)  # Simulate x-axis values with fewer points
# Generate random data for 3 different categories in the field of Science
y = [np.random.uniform(5, 25) * np.cos(x - i) + np.random.uniform(-2, 2, 100) for i in range(3)]

# Text and label configurations
cbar_label = "Scientific Value"
plot_title = "Cosine Scientific Value Distribution"
x_label = "X-axis Values"
y_label = "Cosine Scientific Values"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
legend_location = "upper right"
ylim_values = (-10, 30)
yticks_values = np.arange(-10, 31, 10)
xticks_values = np.arange(0, 11, 2)
cbar_labelpad = 15
cbar_rotation = 270
# Set the figure size
fig, ax = plt.subplots(figsize=(10, 6))

# Create a colorbar with a different colormap
sm = plt.cm.ScalarMappable(cmap="coolwarm", norm=plt.Normalize(vmin=5, vmax=25))
cbar = plt.colorbar(sm, ax=ax, label=cbar_label)
cbar.set_label(cbar_label, rotation=cbar_rotation, labelpad=cbar_labelpad)

# Plotting the data
for i in range(3):
    plt.plot(x, y[i], color=plt.cm.coolwarm(i / 3), alpha=0.8, linewidth=2, label=f'Category {i+1}')

plt.ylim(ylim_values)
plt.title(plot_title)
plt.xlabel(x_label)
plt.ylabel(y_label)
plt.legend(loc=legend_location)

# Customize plot border and ticks
plt.gca().spines["top"].set_visible(False)
plt.gca().spines["right"].set_visible(False)
plt.gca().spines["bottom"].set_visible(True)
plt.gca().spines["left"].set_visible(True)
plt.gca().set_yticks(yticks_values)
plt.gca().set_xticks(xticks_values)

# ===================
# Part 4: Saving Output
# ===================
# Display plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("density_9.pdf", bbox_inches="tight")