import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)


# ===================
# Part 2: Data Preparation
# ===================
# Data
number_of_teams = [1, 2, 3, 4]
baseline_revenue = [60] * len(number_of_teams)
revenue_team_a = [58, 61, 75, 62]
revenue_team_b = [55, 62, 69, 64]
errors = [2, 1.5, 1, 0.5]

# Labels and Plot Types
label1 = "Team A"
label2 = "Team B"
label3 = "Baseline"

# Axes Limits and Labels
xlabel_value = "Number of Sales Teams"
ylabel_value = "Average Revenue (in $1000s)"
title = "Revenue by Number of Sales Teams"
xticklabels = ["1", "2", "3", "4"]
ylim_values = [50, 80]
yticks_values = np.arange(50, 81, 5)
legend_title = "Sales Teams"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
fig, ax = plt.subplots(figsize=(8, 6))  # Adjusted for the given dimensions
bar_width = 0.4
opacity = 0.8

bar1 = ax.bar(
    np.array(number_of_teams) - bar_width / 2,
    revenue_team_a,
    bar_width,
    alpha=opacity,
    color="#41886c",
    label=label1,
    yerr=errors,
    capsize=3,
)

bar2 = ax.bar(
    np.array(number_of_teams) + bar_width / 2,
    revenue_team_b,
    bar_width,
    alpha=opacity,
    color="#b886b3",
    label=label2,
    yerr=errors,
    capsize=3,
)

ax.plot(
    number_of_teams,
    baseline_revenue,
    linestyle="--",
    color="b",
    linewidth=2,
    label=label3,
)

ax.set_xlabel(xlabel_value)
ax.set_ylabel(ylabel_value)
ax.set_title(title)
ax.set_xticks(number_of_teams)
ax.set_xticklabels(xticklabels)
ax.set_ylim(ylim_values)
ax.set_yticks(yticks_values)
ax.legend(loc="upper left", title=legend_title)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig('errorbar_10.pdf', bbox_inches='tight')
