import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)


# ===================
# Part 2: Data Preparation
# ===================
# Define regions as groups
regions = [
    "North America",
    "Europe",
    "Asia",
    "South America",
    "Africa",
    "Australia",
    "Central America",
    "Middle East",
    "Southeast Asia",
    "Scandinavia",
]

# Transportation data: Car Ownership Rates (solid_bar) and Public Transport Usage Rates (striped_bar)
car_ownership_rates = (
    np.array([409.76, 443.03, 420.55, 408.97, 384.73, 429.17, 387.51, 478.35, 492.73, 376.68])
)  # Car ownership rates ranging from 300 to 500 cars per 1000 people
public_transport_usage_rates = (
    np.array([45.83, 40.57, 41.36, 48.51, 31.42, 31.74, 30.40, 46.65, 45.56, 47.40])
)  # Public transport usage rates ranging from 30% to 50%

# Errors for both metrics
car_ownership_errors = np.array([59.14, 51.96, 38.45, 51.22, 24.73, 45.59, 25.73, 57.78, 40.87, 36.58])  # Error bars for car ownership rates
public_transport_errors = np.array([6.58, 9.64, 7.73, 8.41, 5.11, 8.70, 8.67, 8.70, 10.66, 9.09])  # Error bars for public transport usage rates

# Labels and Plot Types
label_Car_Ownership = "Car Ownership Rates"
label_Public_Transport_Usage = "Public Transport Usage Rates"

# Axes Limits and Labels
ylabel_value = "Rates"
title = "Transportation Metrics by Region"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
fig, ax = plt.subplots(figsize=(10, 6))

# X-axis positions for the bars
x = np.arange(len(regions))

# Create vertical stacked bar chart
ax.bar(
    x,
    car_ownership_rates,
    color="#8bb09e",
    yerr=car_ownership_errors,
    label=label_Car_Ownership,
    capsize=3,
)
ax.bar(
    x,
    public_transport_usage_rates,
    bottom=car_ownership_rates,
    color="#eaca8f",
    yerr=public_transport_errors,
    label=label_Public_Transport_Usage,
    capsize=3,
)

# Add labels and title
ax.set_ylabel(ylabel_value)
ax.set_title(title)
ax.set_xticks(x)
ax.set_xticklabels(regions, rotation=45, ha="right")
ax.legend()

# ===================
# Part 4: Saving Output
# ===================
# Show plot
plt.tight_layout()
plt.savefig('errorbar_24.pdf', bbox_inches='tight')
