# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Data for Tech domains
tech_domains = [
    "Biotechnology",
    "Renewable Energy",
    "Nanotechnology",
    "Aerospace Engineering",
    "Genomics",
    "Artificial Intelligence",
]
researcher_count_mean = [85, 95, 70, 120, 100, 110]  # Mean values for researchers
industry_attendee_count_mean = [450, 500, 300, 600, 520, 550]  # Mean values for industry attendees
researcher_count_error = [9, 12, 8, 14, 11, 13]  # Error values for researchers
industry_attendee_count_error = [60, 55, 45, 70, 65, 68]  # Error values for industry attendees
legend_labels = ["Researcher count mean", "Industry attendee count mean"]
y_axis_label = "Number of Researchers"
average_attendee_label = "Average Industry Attendee Count"
plot_title = "Comparison of Researchers and Industry Attendees Across Tech Domains"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================

# Plotting
fig, ax = plt.subplots(figsize=(10, 6))

# Error bars and markers
ax.errorbar(
    tech_domains,
    researcher_count_mean,
    yerr=researcher_count_error,
    fmt="o",
    color="orange",
    marker="^",
    markersize=8,
    label=legend_labels[0],
)
ax.errorbar(
    tech_domains,
    industry_attendee_count_mean,
    yerr=industry_attendee_count_error,
    fmt="o",
    color="purple",
    marker="o",
    markersize=8,
    label=legend_labels[1],
)

# Customization
ax.set_ylabel(y_axis_label)
ax.set_xticklabels(tech_domains, rotation=45, ha="right")
ax.axhline(
    y=sum(industry_attendee_count_mean) / len(industry_attendee_count_mean),
    color="grey",
    linestyle="--",
    linewidth=1.5,
    label=average_attendee_label,
)

# Title and Grid
ax.set_title(plot_title)
ax.grid(True, linestyle='--', linewidth=0.5)

# Legend
ax.legend()

# ===================
# Part 4: Saving Output
# ===================
# Show plot
plt.tight_layout()
plt.savefig("errorpoint_15.pdf", bbox_inches="tight")