# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Example education data
weeks = np.arange(1, 11, 1)
average_test_scores = [85.3, 84.1, 82.9, 88.7, 87.4, 86.2, 90.5, 89.1, 88.3, 87.0]  # Average test scores in percentage
symmetric_error_margin = np.array([1.8, 1.6, 1.5, 1.7, 1.6, 1.9, 1.8, 1.6, 1.9, 2.0])  # Symmetric error
lower_asymmetric_error_margin = 0.7 * symmetric_error_margin  # Adjusted asymmetric error
upper_asymmetric_error_margin = symmetric_error_margin
asymmetric_error_margins = [lower_asymmetric_error_margin, upper_asymmetric_error_margin]

title_symmetric = "Average Test Scores with Symmetric Error Margins Over Time"
title_asymmetric = "Average Test Scores with Asymmetric Error Margins Over Time"
x_label = "Time (Weeks)"
y_label = "Average Test Scores (%)"
legend_label = "Test Score Data"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, (ax0, ax1) = plt.subplots(figsize=(12, 6), ncols=2, sharex=True)

# Plot with symmetric error
ax0.errorbar(
    weeks,
    average_test_scores,
    yerr=symmetric_error_margin,
    fmt="^",
    color="coral",
    ecolor="gray",
    elinewidth=2,
    capsize=5,
    label=legend_label
)
ax0.set_title(title_symmetric, fontsize=14)
ax0.set_xlabel(x_label, fontsize=12)
ax0.set_ylabel(y_label, fontsize=12)
ax0.legend()

# Plot with asymmetric error
ax1.errorbar(
    weeks,
    average_test_scores,
    yerr=asymmetric_error_margins,
    fmt="s",
    color="#2ca02c",
    ecolor="#d62728",
    elinewidth=2,
    capsize=5,
    label=legend_label
)
ax1.set_title(title_asymmetric, fontsize=14)
ax1.set_xlabel(x_label, fontsize=12)
ax1.set_yscale("log")
ax1.legend()

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("errorpoint_18.pdf", bbox_inches="tight")