
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import networkx as nx

# Create a directed graph for hospital departments
G = nx.DiGraph()
# Adding nodes representing departments
G.add_nodes_from([("Assembly Line", {"type": "machine"}), 
                  ("Quality Control", {"type": "process"}), 
                  ("Packaging", {"type": "process"})])

# Adding edges representing interactions
G.add_edges_from([("Assembly Line", "Quality Control"), ("Quality Control", "Packaging"), ("Packaging", "Assembly Line")])

# Adding self-loops representing internal processes
self_loops = [("Assembly Line", "Assembly Line"), ("Quality Control", "Quality Control"), ("Packaging", "Packaging")]
G.add_edges_from(self_loops)

# Positioning nodes in a circular layout
pos = nx.circular_layout(G)

labels = ["Machine-to-Machine Communication", "Internal Machine Processes"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(10, 8))

# Draw nodes and edges with base settings
nx.draw(G, pos, with_labels=True, node_color="violet", node_size=3000, edge_color="gray", linewidths=1.5, font_size=12, font_weight='bold')

# Highlight self-loops with a different style
nx.draw_networkx_edges(G, pos, edgelist=self_loops, edge_color="green", style="dashed", arrowstyle="<|-", arrowsize=20, width=2)

# Adding title and legend
plt.title("Workflow in Automated Manufacturing System", fontsize=16)
edge_legend = plt.Line2D([], [], linestyle="solid", color="gray", label=labels[0])
self_loop_legend = plt.Line2D([], [], linestyle="dashed", color="green", label=labels[1])
plt.legend(handles=[edge_legend, self_loop_legend])

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("graph_13.pdf", bbox_inches="tight")
