# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import networkx as nx

# Create a directed graph to represent species interactions in an ecosystem
species_graph = nx.DiGraph()

# Add nodes representing different species
species_list = ["Rose", "Bee", "Butterfly", "Mushroom", "Grass", "Rabbit", "Eagle", "Hawk"]
species_graph.add_nodes_from(species_list)

# Add edges representing species interactions with weights indicating interaction strength
species_interactions = [
    ("Rose", "Bee", 2), ("Rose", "Butterfly", 3), ("Bee", "Rose", 2),
    ("Butterfly", "Mushroom", 1), ("Grass", "Rabbit", 3), ("Rabbit", "Eagle", 4),
    ("Hawk", "Rabbit", 3), ("Eagle", "Hawk", 2), ("Mushroom", "Grass", 1)
]
species_graph.add_weighted_edges_from(species_interactions)

# Define layout for the graph
layout_positions = nx.spring_layout(species_graph, seed=42)  # Fixed layout for reproducibility

# Create labels for the edges
interaction_labels = nx.get_edge_attributes(species_graph, "weight")

# Title and legend for the plot
plot_title = "Food Web Interactions Among Species in an Ecosystem"
legend_label = ["Interaction Strength"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(12, 10))

# Draw nodes with different colors and sizes based on their degree of interaction
node_sizes = [species_graph.degree(species) * 300 for species in species_graph.nodes()]
nx.draw_networkx_nodes(species_graph, layout_positions, node_size=node_sizes, node_color="lightgreen", edgecolors='black')

# Draw edges with varying thickness based on interaction strength
edge_weights = [species_graph[u][v]['weight'] for u, v in species_graph.edges()]
nx.draw_networkx_edges(species_graph, layout_positions, width=edge_weights, edge_color='brown', arrowstyle='-|>', arrowsize=12)

# Add labels for nodes and edges
nx.draw_networkx_labels(species_graph, layout_positions, font_size=12, font_weight='bold')
nx.draw_networkx_edge_labels(species_graph, layout_positions, edge_labels=interaction_labels, font_color='blue', font_size=10)

# Add title and legend
plt.title(plot_title, fontsize=16)
plt.legend(legend_label, loc="upper right")

# ===================
# Part 4: Saving Output
# ===================
# Show the plot
plt.tight_layout()
plt.savefig("graph_6.pdf", bbox_inches="tight")