import matplotlib.pyplot as plt
import pandas as pd

# ===================
# Part 2: Data Preparation
# ===================
# Define the technology labels
technologies = [
    "AI",
    "Blockchain",
    "Cloud",
    "IoT",
    "AR/VR",
    "Big Data",
    "5G",
    "Quantum Computing",
]

# Define the data for the original and adjusted values
group_a_values = [0.20, 0.10, 0.25, 0.15, 0.05, 0.10, 0.10, 0.05]
group_b_values = [0.15, 0.05, 0.30, 0.20, 0.10, 0.05, 0.10, 0.05]
titles = ["Group A", "Group B"]
# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with two subplots (one for Group A and one for Group B)
fig, (ax1, ax2) = plt.subplots(2, 1, figsize=(10, 8))

# Define the color palette
cmap = plt.get_cmap("coolwarm")

# Plot heatmap for Group A values
im1 = ax1.imshow(pd.DataFrame([group_a_values], columns=technologies), cmap=cmap)
ax1.set_title(titles[0])
ax1.set_xticks(range(len(technologies)))
ax1.set_xticklabels(technologies, rotation=45, ha="center")
ax1.set_yticks(range(1))
ax1.set_yticklabels([""], rotation=0)

# Add annotations for Group A values
for i in range(1):
    for j in range(len(technologies)):
        ax1.text(
            j, i, f"{group_a_values[j]:.2f}", ha="center", va="center", color="black"
        )

# Plot heatmap for Group B values
im2 = ax2.imshow(pd.DataFrame([group_b_values], columns=technologies), cmap=cmap)
ax2.set_title(titles[1])
ax2.set_xticks(range(len(technologies)))
ax2.set_xticklabels(technologies, rotation=45, ha="center")
ax2.set_yticks(range(1))
ax2.set_yticklabels([""], rotation=0)

# Add annotations for Group B values
for i in range(1):
    for j in range(len(technologies)):
        ax2.text(
            j, i, f"{group_b_values[j]:.2f}", ha="center", va="center", color="black"
        )

# Display the figure
plt.subplots_adjust(hspace=-0.5)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig('heatmap_20.pdf', bbox_inches='tight')
