import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)

# ===================
# Part 2: Data Preparation
# ===================
# Placeholder data for energy consumption matrices
data_solar = np.array([[50, 10, 5, 0], [8, 40, 2, 0], [3, 7, 25, 5], [0, 0, 4, 40]])
data_wind = np.array([[45, 12, 3, 0], [5, 30, 8, 2], [1, 6, 15, 10], [0, 0, 5, 35]])
data_hydro = np.array([[100, 20, 5, 5], [15, 70, 20, 10], [5, 15, 55, 25], [0, 0, 10, 95]])
data_nuclear = np.array([[300, 50, 20, 10], [30, 200, 80, 20], [10, 50, 250, 60], [0, 5, 70, 300]])
data_coal = np.array([[200, 60, 30, 10], [40, 150, 50, 20], [20, 40, 130, 60], [5, 10, 50, 200]])
data_natural_gas = np.array([[350, 90, 40, 20], [80, 220, 90, 60], [30, 70, 250, 100], [10, 20, 60, 350]])
data_biomass = np.array([[25, 5, 2, 1], [5, 15, 8, 2], [2, 5, 12, 4], [1, 2, 5, 18]])
data_geothermal = np.array([[500, 100, 50, 20], [90, 300, 150, 50], [40, 100, 350, 150], [20, 30, 120, 400]])

# Titles for the subplots
titles = ["Solar", "Wind", "Hydro", "Nuclear", "Coal", "Natural Gas", "Biomass", "Geothermal"]
xlabel = "Predicted usage category"
ylabel = "Actual usage category"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, axes = plt.subplots(nrows=2, ncols=4, figsize=(12, 6))  # Adjusted for 1080x2376

# Function to create a single confusion matrix plot
def plot_confusion_matrix(ax, data, title):
    im = ax.imshow(data, interpolation="nearest", cmap="viridis")
    ax.figure.colorbar(im, ax=ax)
    ax.set(
        title=title,
        xlabel=xlabel,
        ylabel=ylabel,
        xticks=np.arange(data.shape[1]),
        yticks=np.arange(data.shape[0]),
    )
    # Loop over data dimensions and create text annotations.
    for i in range(data.shape[0]):
        for j in range(data.shape[1]):
            ax.text(j, i, data[i, j], ha="center", va="center", color="w")

# Plot each confusion matrix
plot_confusion_matrix(axes[0, 0], data_solar, titles[0])
plot_confusion_matrix(axes[0, 1], data_wind, titles[1])
plot_confusion_matrix(axes[0, 2], data_hydro, titles[2])
plot_confusion_matrix(axes[0, 3], data_nuclear, titles[3])
plot_confusion_matrix(axes[1, 0], data_coal, titles[4])
plot_confusion_matrix(axes[1, 1], data_natural_gas, titles[5])
plot_confusion_matrix(axes[1, 2], data_biomass, titles[6])
plot_confusion_matrix(axes[1, 3], data_geothermal, titles[7])

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better fit and save the figure
plt.tight_layout()
plt.savefig('heatmap_5.pdf', bbox_inches='tight')
