import numpy as np; np.random.seed(0); np.random.seed(0)

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Sample data for demonstration
data_upper = np.array([[0.55, 0.72, 0.6, 0.54, 0.42], [0.65, 0.44, 0.89, 0.96, 0.38], [0.79, 0.53, 0.57, 0.93, 0.07]])  # Data for the upper subplot
data_lower = np.array([[0.09, 0.02, 0.83, 0.78, 0.87], [0.98, 0.8, 0.46, 0.78, 0.12], [0.64, 0.14, 0.94, 0.52, 0.41]])  # Data for the lower subplot

# Common labels for both subplots
subjects = [
    "Math",
    "Science",
    "English",
]
grades = list(range(1, 6))

# Axes Limits and Labels
title = "School Performance Analysis - Test Scores"
xlabel_value = "Grades"
xticks_values = [0, 1, 2, 3, 4]
xticklabels = [0, 1, 2, 3, 4]
yticks_values = range(len(subjects))

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure and two subplots
fig, (ax1, ax2) = plt.subplots(2, 1, figsize=(8, 10))  # Adjust figsize as needed

# First subplot: Test Scores
im1 = ax1.imshow(data_upper, cmap="Purples")
ax1.set_title(title)
# Hide x-axis labels and ticks for the first subplot
ax1.set_yticks(range(len(subjects)))
ax1.set_yticklabels(subjects)

# Second subplot: Participation Rates
im2 = ax2.imshow(data_lower, cmap="Purples")
# Set x-axis label and ticks for the second subplot
ax2.set_xlabel(xlabel_value)
ax2.set_xticks(xticks_values)  # Show ticks at [0, 5, 10, 15]
ax2.set_xticklabels(xticklabels)  # Label ticks at [1, 6, 11, 16]
ax2.set_yticks(yticks_values)
ax2.set_yticklabels(subjects)

# ===================
# Part 4: Saving Output
# ===================
# Show the entire figure with tight layout to minimize white space
plt.tight_layout()
plt.savefig('heatmap_9.pdf', bbox_inches='tight')
