import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)

# ===================
# Part 2: Data Preparation
# ===================
# Sample data with modified distributions for technology domain
correctly_classified = np.array([0.64, 1.0, 0.74, 0.63, 0.44, 0.83, 0.46, 1.78, 2.65, 0.39, 1.26, 0.6, 0.67, 2.08, 0.06, 0.07, 0.02, 1.43, 1.2, 1.63, 3.08, 1.28, 0.5, 1.21, 0.1, 0.82, 0.12, 2.32, 0.59, 0.43, 0.25, 1.19, 0.49, 0.67, 0.02, 0.77, 0.76, 0.77, 2.3, 0.92, 0.36, 0.46, 0.96, 0.05, 0.88, 0.89, 0.19, 0.11, 0.3, 0.36, 0.68, 0.46, 3.56, 0.09, 0.19, 0.14, 0.85, 0.23, 0.5, 0.22, 0.14, 0.09, 0.85, 0.12, 0.18, 0.37, 1.38, 0.08, 1.46, 0.08, 3.0, 0.51, 3.01, 0.74, 1.08, 0.03, 0.27, 0.1, 0.28, 0.1, 0.31, 0.43, 0.05, 0.94, 0.67, 0.25, 0.59, 0.08, 0.69, 2.12, 0.31, 0.88, 0.11, 1.01, 0.27, 0.16, 0.71, 0.02, 1.41, 0.0])
misclassified = np.array([2.88, 2.2, 2.49, 3.12, 2.93, 1.51, 2.48, 1.92, 1.95, 2.21, 2.07, 2.73, 2.38, 2.06, 2.22, 2.17, 2.75, 1.9, 2.16, 1.57, 0.72, 2.33, 2.43, 1.63, 3.13, 1.27, 2.02, 1.91, 2.77, 2.73, 2.08, 2.19, 1.56, 1.01, 1.83, 2.08, 2.62, 2.6, 1.81, 1.85, 1.48, 1.29, 1.15, 2.98, 1.75, 1.78, 1.37, 2.39, 1.19, 1.89, 1.55, 2.19, 1.74, 1.41, 1.99, 2.21, 2.03, 2.15, 1.68, 1.82, 1.66, 1.82, 1.59, 1.14, 2.09, 1.8, 1.18, 2.23, 1.55, 2.03, 2.36, 2.06, 2.57, 1.38, 2.2, 1.66, 1.56, 1.71, 1.84, 2.03, 1.42, 2.45, 2.23, 1.23, 2.74, 2.95, 2.59, 1.91, 1.46, 2.53, 1.8, 2.61, 2.1, 2.49, 2.18, 2.35, 2.01, 2.89, 2.06, 2.2])

# Labels and Plot Types
hist_label = ["Correctly Classified Devices", "Misclassified Devices"]

# Axes Limits and Labels
xlabel_value = "Distance to Decision Boundary"
ylabel_value = "Frequency"
title = "Machine Learning Model Accuracy Analysis"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size
plt.figure(figsize=(5, 4))

# Plot histograms with stacked bars, modified colors, and alpha for transparency
plt.hist(
    [correctly_classified, misclassified],
    bins=50,
    stacked=True,
    label=hist_label,
    color=["#6495ED", "#FFA07A"],
    alpha=0.6,
)

# Add labels, title, and modify the style of the labels
plt.xlabel(xlabel_value, color="#333333")
plt.ylabel(ylabel_value, color="#333333")
plt.title(title)

# Modify the legend style and position to lower center
plt.legend(frameon=True, loc="lower center", ncol=2, bbox_to_anchor=(0.5, -0.4))

# Adjust x-axis range and add some space at the beginning of the x-axis
plt.xlim(left=plt.xlim()[0] + 0.1, right=3)  # Adjusted right xlim

# Add grid with lighter color and set behind the histograms
plt.grid(color="grey", linestyle="--", linewidth=0.5, alpha=0.7)
plt.gca().set_axisbelow(True)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the plot
plt.tight_layout()
plt.savefig('hist_16.pdf', bbox_inches='tight')
