
import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np; np.random.seed(0)

line_label_base = "System Base"
line_label_ours = "System Ours"
xlim_values = (0, 200)
ylim_values_eei = (0.5, 1.0)
ylim_values_ris = (0.1, 0.6)
ylim_values_gsf = (0.0, 0.5)
ylim_values_eis = (0.2, 0.7)
xlabel_value = "Testing Iterations"
ylabel_value_eei = "Energy Efficiency Index (↑)"
ylabel_value_ris = "Renewable Integration Score (↑)"
ylabel_value_gsf = "Grid Stability Factor (↑)"
ylabel_value_eis = "Environmental Impact Score (↓)"
yticks_values_eei = [0.5, 0.6, 0.7, 0.8, 0.9, 1.0]
yticks_values_ris = [0.1, 0.2, 0.3, 0.4, 0.5, 0.6]
yticks_values_gsf = [0.0, 0.1, 0.2, 0.3, 0.4, 0.5]
yticks_values_eis = [0.2, 0.3, 0.4, 0.5, 0.6, 0.7]

# Simulated data
iterations = np.linspace(0, 200, 21)
iterations = [0., 10., 20., 30., 40., 50., 60., 70., 80., 90., 100., 110., 120., 130.,
 140., 150., 160., 170., 180., 190., 200.]

# Energy Efficiency Index (EEI)

base_data_eei = [0.95, 0.93, 0.92, 0.90, 0.88, 0.87, 0.85, 0.83, 0.82, 0.80, 0.78, 0.77, 0.75, 0.73,
                 0.71, 0.70, 0.68, 0.66, 0.65, 0.63, 0.61]
ours_data_eei = [0.55, 0.57, 0.58, 0.60, 0.62, 0.63, 0.65, 0.67, 0.68, 0.70, 0.72, 0.73, 0.75, 0.77,
                 0.78, 0.80, 0.82, 0.83, 0.85, 0.87, 0.88]

# Renewable Integration Score (RIS)
base_data_ris = [0.20, 0.25, 0.30, 0.35, 0.40, 0.45, 0.50, 0.47, 0.44, 0.41, 0.38, 0.35, 0.32, 0.29,
                 0.26, 0.23, 0.20, 0.25, 0.30, 0.35, 0.40]
ours_data_ris = [0.40, 0.35, 0.30, 0.25, 0.20, 0.15, 0.10, 0.13, 0.16, 0.19, 0.22, 0.25, 0.28, 0.31,
                 0.34, 0.37, 0.40, 0.35, 0.30, 0.25, 0.20]


# Grid Stability Factor (GSF)
base_data_gsf = [0.45, 0.43, 0.42, 0.40, 0.38, 0.36, 0.35, 0.33, 0.31, 0.29, 0.28, 0.26, 0.24, 0.22,
                 0.21, 0.19, 0.17, 0.15, 0.14, 0.12, 0.10]
ours_data_gsf = [0.05, 0.07, 0.09, 0.11, 0.13, 0.15, 0.17, 0.19, 0.21, 0.23, 0.25, 0.27, 0.29, 0.31,
                 0.33, 0.35, 0.37, 0.39, 0.41, 0.43, 0.45]

# Environmental Impact Score (EIS)
base_data_eis = [0.65, 0.60, 0.55, 0.50, 0.45, 0.40, 0.35, 0.38, 0.41, 0.44, 0.47, 0.50, 0.53, 0.50,
                 0.47, 0.44, 0.41, 0.38, 0.35, 0.40, 0.45]
ours_data_eis = [0.35, 0.40, 0.45, 0.50, 0.55, 0.60, 0.65, 0.63, 0.61, 0.59, 0.57, 0.55, 0.53, 0.51,
                 0.49, 0.47, 0.45, 0.43, 0.41, 0.39, 0.37]


legend_location = "upper center"
legend_bbox_to_anchor = (0.5, 1.2)
legend_frameon = False
legend_ncol = 2
grid_value = True
# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting FID
# Create subplots
fig, axs = plt.subplots(4, 1, figsize=(8, 10))

axs[0].plot(iterations, base_data_eei, label=line_label_base, color="blue")
axs[0].plot(iterations, ours_data_eei, label=line_label_ours, color="orange")
axs[0].set_xlabel(xlabel_value)
axs[0].set_ylabel(ylabel_value_eei)
axs[0].set_xlim(*xlim_values)
axs[0].set_yticks(yticks_values_eei)
axs[0].tick_params(axis="both", which="both", color="gray")

axs[1].plot(iterations, base_data_ris, label=line_label_base, color="blue")
axs[1].plot(iterations, ours_data_ris, label=line_label_ours, color="orange")
axs[1].set_xlabel(xlabel_value)
axs[1].set_ylabel(ylabel_value_ris)
axs[1].set_xlim(*xlim_values)
axs[1].set_yticks(yticks_values_ris)
axs[1].tick_params(axis="both", which="both", color="gray")

# Plotting CW-FID
axs[2].plot(iterations, base_data_gsf, label=line_label_base, color="blue")
axs[2].plot(iterations, ours_data_gsf, label=line_label_ours, color="orange")
axs[2].set_xlabel(xlabel_value)
axs[2].set_ylabel(ylabel_value_gsf)
axs[2].set_xlim(*xlim_values)
axs[2].set_yticks(yticks_values_gsf)
axs[2].tick_params(axis="both", which="both", color="gray")

# Plotting CAS
axs[3].plot(iterations, base_data_eis, label=line_label_base, color="blue")
axs[3].plot(iterations, ours_data_eis, label=line_label_ours, color="orange")
axs[3].set_xlabel(xlabel_value)
axs[3].set_ylabel(ylabel_value_eis)
axs[3].set_xlim(*xlim_values)
axs[3].set_yticks(yticks_values_eis)
axs[3].tick_params(axis="both", which="both", color="gray")

# Add legends and gridlines to each subplot
for ax in axs.flat:
    ax.legend(loc=legend_location, bbox_to_anchor=legend_bbox_to_anchor, frameon=legend_frameon, ncol=legend_ncol)
    ax.grid(grid_value)  # Enable the grid

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the plot
plt.tight_layout()
plt.savefig('line_13.pdf', bbox_inches='tight')
