import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)


# ===================
# Part 2: Data Preparation
# ===================
# Sample data
weeks = [1, 4, 7, 10, 13, 16, 19, 22, 25, 28]
ev_usage = np.array([0.05, 0.2, 0.3, 0.4, 0.7, 0.9, 0.8, 0.6, 0.5, 0.4])
gasoline_usage = np.array([0.9, 0.8, 0.75, 0.7, 0.6, 0.5, 0.4, 0.35, 0.3, 0.25])

# Axes Limits and Labels
xlabel_value = "Week"
xlim_values = [1, 28]

ylabel_value = "Usage (Normalized)"
ylim_values = [0, 1.0]
yticks_values = [0, 0.25, 0.5, 0.75, 1.0]

axvspan1_l, axvspan1_r = 10, 19
axvspan2_l, axvspan2_r = 19, 26

# Labels
label_1 = "Electric Vehicles"
label_2 = "Gasoline Vehicles"

# Annotations
annotation_1 = "New EV model"
annotation_2 = "Gasoline recall"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axis
fig, ax = plt.subplots(figsize=(6, 4))

# Plot the data
ax.plot(weeks, ev_usage, "r-x", label=label_1)
ax.plot(weeks, gasoline_usage, "o-.", label=label_2)

# Highlight specific regions
ax.axvspan(axvspan1_l, axvspan1_r, color="peachpuff", alpha=0.5)
ax.axvspan(axvspan2_l, axvspan2_r, color="paleturquoise", alpha=0.5)

# Annotations
ax.annotate(
    annotation_1,
    xy=(12, 0.7),
    xytext=(14, 0.8),
    arrowprops=dict(facecolor="yellow", shrink=0.05),
)
ax.annotate(
    annotation_2,
    xy=(21, 0.4),
    xytext=(23, 0.5),
    arrowprops=dict(facecolor="cyan", shrink=0.05),
)

# Set labels and title
ax.set_xlabel(xlabel_value)
ax.set_xlim(xlim_values)
ax.set_ylim(ylim_values)
ax.set_yticks(yticks_values)
ax.set_xticks(weeks)
ax.set_ylabel(ylabel_value)

# Add legend
ax.legend(loc="upper left")

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig('line_14.pdf', bbox_inches='tight')
