import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)


# ===================
# Part 2: Data Preparation
# ===================
# Define subplot titles
titles = [
    "Sedan",
    "SUV",
    "Truck",
    "Minivan",
]

# Sample data for plotting
ratios = np.linspace(0.1, 1.0, 5)
sedan_standard = np.array([32.74, 33.58, 33.01, 32.72, 32.12])
sedan_hybrid = np.array([42.74, 43.58, 43.01, 42.72, 42.12])
suv_standard = np.array([23.23, 22.19, 24.46, 24.82, 21.92])
suv_hybrid = np.array([28.96, 27.64, 27.84, 29.63, 25.36])
truck_standard = np.array([17.74, 18.58, 18.01, 17.72, 17.12])
truck_hybrid = np.array([23.23, 22.19, 24.46, 24.82, 21.92])
minivan_standard = np.array([21.96, 20.64, 20.84, 22.63, 18.36])
minivan_hybrid = np.array([25.44, 25.1, 29.16, 28.89, 29.35])

# Average performances for GSAT
sedan_gsat = np.mean(sedan_standard) * np.ones(len(ratios))
sedan_hybrid_gsat = np.mean(sedan_hybrid) * np.ones(len(ratios))
suv_gsat = np.mean(suv_standard) * np.ones(len(ratios))
suv_hybrid_gsat = np.mean(suv_hybrid) * np.ones(len(ratios))
truck_gsat = np.mean(truck_standard) * np.ones(len(ratios))
truck_hybrid_gsat = np.mean(truck_hybrid) * np.ones(len(ratios))
minivan_gsat = np.mean(minivan_standard) * np.ones(len(ratios))
minivan_hybrid_gsat = np.mean(minivan_hybrid) * np.ones(len(ratios))

# Error for sample data
error = np.random.uniform(0.5, 1, len(ratios))

# Axes Limits and Labels
xlabel_value = "Load Ratio"
ylabel_value = "Fuel Efficiency (MPG)"

# Labels
label_standard = "Standard"
label_hybrid = "Hybrid"
label_gsat_standard = "Standard (GSAT)"
label_gsat_hybrid = "Hybrid (GSAT)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set figure size to match the original image's dimensions
plt.figure(figsize=(16, 8))

# Plot data for each vehicle type
for i, (title, standard, hybrid, standard_gsat, hybrid_gsat) in enumerate(
    zip(titles, 
        [sedan_standard, suv_standard, truck_standard, minivan_standard], 
        [sedan_hybrid, suv_hybrid, truck_hybrid, minivan_hybrid], 
        [sedan_gsat, suv_gsat, truck_gsat, minivan_gsat], 
        [sedan_hybrid_gsat, suv_hybrid_gsat, truck_hybrid_gsat, minivan_hybrid_gsat])):

    plt.subplot(2, 2, i + 1)
    plt.plot(ratios, standard, "-s", label=label_standard, color="purple")
    plt.fill_between(
        ratios,
        standard - error,
        standard + error,
        color="purple",
        alpha=0.2,
    )
    plt.plot(ratios, hybrid, "-s", label=label_hybrid, color="orange")
    plt.fill_between(
        ratios,
        hybrid - error,
        hybrid + error,
        color="orange",
        alpha=0.2,
    )
    plt.plot(ratios, standard_gsat, "--", label=label_gsat_standard, color="purple")
    plt.plot(ratios, hybrid_gsat, "--", label=label_gsat_hybrid, color="orange")
    plt.title(title)
    plt.xlabel(xlabel_value)
    plt.ylabel(ylabel_value)
    plt.legend(loc="upper right")
    plt.grid(True)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout
plt.tight_layout()

# Show the plot
plt.savefig('line_20.pdf', bbox_inches='tight')
