
import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)

# ===================
# Part 2: Data Preparation
# ===================
# Data for plotting
speed_limits = ["30 km/h", "40 km/h", "50 km/h", "60 km/h", "70 km/h", "80 km/h", "90 km/h", "100 km/h", "110 km/h"]
urban_accidents = [10, 12, 15, 18, 22, 25, 28, 30, 32]
suburban_accidents = [8, 10, 13, 16, 20, 23, 25, 27, 29]

# Variables for plot configuration
urban_label = "Urban Area"
suburban_label = "Suburban Area"
xlim_values = (0, len(speed_limits) - 1)
ylim_values = (5, 35)
xlabel_text = "Speed Limit (km/h)"
ylabel_text = "Accident Rate (%)"
xticks_values = np.arange(len(speed_limits))
yticks_values = [5, 10, 15, 20, 25, 30, 35]
xtickslabel_fontsize = 16
ytickslabel_fontsize = 16


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the lines
plt.figure(figsize=(9, 6))  # Adjusting figure size
plt.plot(
    speed_limits,
    urban_accidents,
    marker="o",
    linestyle="--",
    linewidth=4,
    clip_on=False,
    zorder=10,
    color="#1f77b4",
    markersize=12,
    label=urban_label,
    mec="#4682b4",
    mfc="white",
    mew=4,
)  # Adjusted color and marker size
plt.plot(
    speed_limits,
    suburban_accidents,
    marker="s",
    linestyle="-.",
    linewidth=4,
    clip_on=False,
    zorder=10,
    color="#2ca02c",
    markersize=12,
    label=suburban_label,
    mec="#008b74",
    mfc="white",
    mew=4,
)  # Adjusted color, line style, and marker size

# Adding titles and labels with increased font size
plt.yticks(yticks_values, fontsize=ytickslabel_fontsize)
plt.xticks(xticks_values, fontsize=xtickslabel_fontsize)
plt.ylim(*ylim_values)
plt.xlim(*xlim_values)
plt.xlabel(xlabel_text, fontsize=xtickslabel_fontsize)
plt.ylabel(ylabel_text, fontsize=ytickslabel_fontsize)

# Adding legend with square markers
plt.legend(
    markerscale=1,
    fontsize=16,
    loc="lower center",
    bbox_to_anchor=(0.5, -0.25),
    ncol=2,
    frameon=False,
)

# Changing the background color to #f5f5f5
plt.gca().set_facecolor("#f5f5f5")

# Change the axis colors
ax = plt.gca()
ax.spines["bottom"].set_color("#f5f5f5")
ax.spines["top"].set_color("#f5f5f5")  # Optional: hide or set color
ax.spines["left"].set_color("#f5f5f5")
ax.spines["right"].set_color("#f5f5f5")  # Optional: hide or set color

plt.tick_params(axis="both", which="both", length=0)
# Adding grid
plt.grid(True, color="white")

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to add more space on the right
plt.tight_layout()
plt.savefig('line_21.pdf', bbox_inches='tight')
