import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)


# ===================
# Part 2: Data Preparation
# ===================
# Data corrected to match lengths
x = [2**0.2, 2**1, 2**2, 2**3, 2**4, 2**5, 2**6, 2**7, 2**8.6]
y = [
    60.5,
    65.3,
    70.2,
    75.0,
    78.6,
    80.1,
    82.5,
    85.0,
    87.3,
]
labels = [
    "60.5",
    "65.3",
    "70.2",
    "75.0",
    "78.6",
    "80.1",
    "82.5",
    "85.0",
    "87.3",
]

# Axes Limits and Labels
xlabel_value = "Number of Vehicles (hundreds)"
xlim_values = [2**0, 2**8]
xticks_values = [2**1, 2**3, 2**5, 2**7]
xticklabels = ["$2^{1}$", "$2^{3}$", "$2^{5}$", "$2^{7}$"]

ylabel_value = "Average Speed (km/h)"
ylim_values = [50, 110]
yticks_values = np.arange(50, 111, 10)

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
fig, ax = plt.subplots(
    figsize=(5, 2)
)  # Adjust the size to match the original image's dimensions
ax.plot(
    x,
    y,
    marker="o",
    color="#4c72b0",
    linestyle="-",
    linewidth=2,
    markersize=6,
    mfc="#ff8c00",
    mec="white",
)

# Annotate each point with its label
for i, label in enumerate(labels):
    ax.annotate(
        label,
        (x[i], y[i]),
        textcoords="offset points",
        xytext=(0, 10),
        ha="center",
        fontsize=7,
    )

# Set x-axis to be logarithmic
ax.set_xscale("log", base=2)  # Corrected 'basex' to 'base'

# Set x-axis labels to be in the format of 2^n
ax.set_xticks(xticks_values)
ax.set_xticklabels(
    xticklabels,
)
ax.set_xlim(xlim_values)  # Set limits to include a small margin

# Set y-axis ticks
plt.yticks(yticks_values, fontsize=10)
plt.ylim(ylim_values)  # Adjusted y-axis limit

# Remove tick lines outside the plotting area
ax.tick_params(
    axis="both", which="both", length=0, color="#d2d2d2"
)  # Remove tick marks and set their color

# Set labels and title
plt.xlabel(xlabel_value)
plt.ylabel(ylabel_value)

# Change the plot background color
ax.set_facecolor("#eaeaf2")

# Show grid
plt.grid(True, which="both", linestyle="-", linewidth=1, color="white")

# Change the axis colors
ax = plt.gca()
ax.spines["bottom"].set_color("#f5f5f5")
ax.spines["top"].set_color("#f5f5f5")  # Optional: hide or set color
ax.spines["left"].set_color("#f5f5f5")
ax.spines["right"].set_color("#f5f5f5")  # Optional: hide or set color

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to add more space on the right
plt.tight_layout()
plt.savefig('line_23.pdf', bbox_inches='tight')
