import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)


# ===================
# Part 2: Data Preparation
# ===================
# Dummy data for the purpose of plotting. In a real scenario, you would use your actual data.
number_of_vehicles = np.array([10, 20, 40, 80])

# Average Fuel Efficiency (MPG)
baseline_efficiency = np.array([20, 21, 22, 22.5])
method1_efficiency = np.array([18, 19, 20, 21])
method2_efficiency = np.array([15, 16.5, 17, 18])

# Error for Fuel Efficiency
error_efficiency = np.array([0.5, 0.5, 0.5, 0.5])

# Average Travel Time (minutes)
baseline_time = np.array([35, 40, 45, 50])
method1_time = np.array([38, 42, 47, 52])
method2_time = np.array([40, 45, 50, 55])

# Error for Travel Time
error_time = np.array([1, 1, 1, 1])

# Axes Limits and Labels
ylabel_value_1 = "Average Fuel Efficiency (MPG)"
ylabel_value_2 = "Average Travel Time (minutes)"
ylim_values_1 = [14, 24]
yticks_values_1 = np.arange(15, 23, 2)
ylim_values_2 = [30, 60]
yticks_values_2 = np.arange(35, 56, 5)

# Labels
label_Baseline = "Baseline"
label_Method1 = "Alternative Method 1"
label_Method2 = "Alternative Method 2"

# Texts
text_1 = "Number of Vehicles"
text_2 = "Comparison Metrics"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create two subplots and unpack the output array immediately
f, (ax1, ax2) = plt.subplots(2, 1, sharex=True, figsize=(8, 6))

# First subplot for Fuel Efficiency
ax1.errorbar(
    number_of_vehicles,
    baseline_efficiency,
    yerr=error_efficiency,
    label=label_Baseline,
    color="#3171ad",
    marker="o",
)
ax1.errorbar(
    number_of_vehicles,
    method1_efficiency,
    yerr=error_efficiency,
    label=label_Method1,
    color="#469c76",
    marker="o",
)
ax1.errorbar(
    number_of_vehicles,
    method2_efficiency,
    yerr=error_efficiency,
    label=label_Method2,
    color="#c17cb9",
    marker="o",
)
ax1.set_ylabel(ylabel_value_1)
# Set grid
ax1.grid(True)
ax1.set_ylim(ylim_values_1)
ax1.set_yticks(yticks_values_1)

# Second subplot for Travel Time
ax2.errorbar(
    number_of_vehicles,
    baseline_time,
    yerr=error_time,
    label=label_Baseline,
    color="#3171ad",
    marker="o",
)
ax2.errorbar(
    number_of_vehicles,
    method1_time,
    yerr=error_time,
    label=label_Method1,
    color="#469c76",
    marker="o",
)
ax2.errorbar(
    number_of_vehicles,
    method2_time,
    yerr=error_time,
    label=label_Method2,
    color="#c17cb9",
    marker="o",
)
ax2.set_ylabel(ylabel_value_2)
# Set grid
ax2.grid(True)
ax2.set_ylim(ylim_values_2)
ax2.set_yticks(yticks_values_2)

# Only show ticks on the bottom subplot
plt.setp(ax1.get_xticklabels(), visible=False)

# Create legend above the second subplot
ax2.legend(loc="upper center", bbox_to_anchor=(0.5, 1.2), ncol=3)

# Set the figure's layout so there is space for the xlabel at the bottom
plt.tight_layout()

# Now adjust the subplot to give space for the ylabel on the left
f.subplots_adjust(left=0.15, bottom=0.12)

# Place the legend and adjust subplot parameters
ax2.legend(loc="upper center", bbox_to_anchor=(0.5, 1.2), ncol=3)

f.text(0.55, 0.05, text_1, ha="center", va="center")
f.text(
    0.05,
    0.5,
    text_2,
    ha="center",
    va="center",
    rotation="vertical",
)

# ===================
# Part 4: Saving Output
# ===================
plt.savefig('line_25.pdf', bbox_inches='tight')
