
import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)

from matplotlib.ticker import MultipleLocator

# ===================
# Part 2: Data Preparation
# ===================
# Data for plotting
battery_capacities = ["256Wh", "512Wh", "1024Wh", "2048Wh", "4096Wh", "8192Wh", "16384Wh"]
lithium_ion_values = [0.85, 0.87, 0.90, 0.92, 0.92, 0.92, 0.92]
lead_acid_values = [0.75, 0.78, 0.82, 0.85, 0.88, 0.88, 0.88]
flow_battery_values = [0.65, 0.70, 0.75, 0.80, 0.78, 0.76, 0.74]

# Variables for plot configuration
line_labels = ["Lithium-ion", "Lead-acid", "Flow Battery"]
xlim_values = (0, len(battery_capacities) - 1)
ylim_values = (0.6, 1.0)
xlabel_value = "Battery Capacity"
xticks_values = range(len(battery_capacities))
yticks_values = np.arange(0.6, 1.1, 0.1)
xtickslabel_values = battery_capacities
title_value = "Efficiency of Energy Storage Technologies"
# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the lines
plt.figure(figsize=(8, 6))
plt.plot(
    battery_capacities,
    lithium_ion_values,
    "o--",
    clip_on=False,
    zorder=10,
    color="#0c5da5",
    label=line_labels[0],
)
plt.plot(
    battery_capacities,
    lead_acid_values,
    "o--",
    clip_on=False,
    zorder=10,
    color="#ff9500",
    label=line_labels[1],
)
plt.plot(
    battery_capacities,
    flow_battery_values,
    "o--",
    clip_on=False,
    zorder=10,
    color="#00b945",
    label=line_labels[2],
)

# Setting x and y ticks
plt.xticks(xticks_values, xtickslabel_values, fontsize=14)
plt.xlim(xlim_values)
plt.yticks(yticks_values, fontsize=14)

# Adding minor y-axis ticks with a step of 0.05
ax = plt.gca()
# ax.yaxis.set_minor_locator(MultipleLocator(0.05))

# Adjust tick parameters
ax.tick_params(axis="both", which="both", length=5, color="gray")  # Move ticks inside
ax.tick_params(
    axis="y", which="minor", length=2
)  # Ensure minor ticks are visible but smaller

# Title and labels
plt.title(title_value, fontsize=14)
plt.xlabel(xlabel_value, fontsize=14)

# Enable gridlines for minor ticks
plt.grid(True, color="#b0b0b0", which="major", linestyle="-", linewidth=0.5)

# Legend with serif font family
plt.legend(
    frameon=False, fontsize=12, loc="lower center", bbox_to_anchor=(0.5, -0.2), ncol=3
)

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to add more space on the right
plt.tight_layout()

plt.savefig('line_26.pdf', bbox_inches='tight')

