import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Data for plotting
vehicle_speeds = [20, 40, 60, 80]
sedan_consumption = [15.0, 13.5, 12.5, 14.0]
suv_consumption = [10.5, 9.0, 8.0, 9.5]
truck_consumption = [8.5, 7.0, 6.5, 7.2]

# Axes Limits and Labels
xlabel_value = "Speed (km/h)"
xlim_values = [10, 90]
xticks_values = [20, 40, 60, 80]
xticklabels = ["$20$", "$40$", "$60$", "$80$"]

ylabel_value = "Fuel Consumption (liters/100 km)"

# Labels
label_Sedan = "Sedan"
label_SUV = "SUV"
label_Truck = "Truck"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the data
plt.figure(figsize=(6, 6))  # Adjusting figure size to match original image dimensions
plt.plot(
    vehicle_speeds, sedan_consumption, "o-", label=label_Sedan, color="#e8d2cc", markersize=4
)
plt.plot(
    vehicle_speeds, suv_consumption, "x-", label=label_SUV, color="#9f6a8d", markersize=4
)
plt.plot(
    vehicle_speeds, truck_consumption, "s-", label=label_Truck, color="#5c5048", markersize=4
)

# Set x-axis to only display specific ticks and extend y-axis to leave space at top
plt.xticks(xticks_values, xticklabels)
plt.xlim(xlim_values)

# Adding data labels
for i, txt in enumerate(sedan_consumption):
    plt.annotate(
        txt,
        (vehicle_speeds[i], sedan_consumption[i]),
        textcoords="offset points",
        xytext=(0, 5),
        ha="center",
        fontsize=12,
    )
for i, txt in enumerate(suv_consumption):
    plt.annotate(
        txt,
        (vehicle_speeds[i], suv_consumption[i]),
        textcoords="offset points",
        xytext=(0, 5),
        ha="center",
        fontsize=12,
    )
for i, txt in enumerate(truck_consumption):
    plt.annotate(
        txt,
        (vehicle_speeds[i], truck_consumption[i]),
        textcoords="offset points",
        xytext=(0, 5),
        ha="center",
        fontsize=12,
    )

# Setting the axis labels
plt.xlabel(xlabel_value, fontsize=16)
plt.ylabel(ylabel_value, fontsize=16)

# Change the axis colors
ax = plt.gca()
ax.spines["bottom"].set_color("#cccccc")
ax.spines["bottom"].set_linewidth(1.4)
ax.spines["left"].set_color("#cccccc")
ax.spines["left"].set_linewidth(1.4)
ax.spines["top"].set_color("#ffffff")
ax.spines["right"].set_color("#ffffff")

# Adjust tick parameters to ensure ticks do not extend outside
ax.tick_params(axis="both", which="both", length=0)  # Hide tick marks

# Adding the legend
plt.legend(loc="upper left")

# Adding grid
plt.grid(True, which="both", linestyle="--", linewidth=1, color="#808080")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save plot
plt.tight_layout()
plt.savefig('line_27.pdf', bbox_inches='tight')
