import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)


# ===================
# Part 2: Data Preparation
# ===================
# Data
x = [0, 25, 50, 75, 100, 125, 150, 175, 200]
model_a_y = [24, 26, 28, 30, 32, 31, 29, 28, 27]
model_b_y = [22, 24, 26, 28, 29, 30, 31, 32, 33]
baseline_fuel_efficiency = 24

# Axes Limits and Labels
xlabel_value = "Number of Test Miles"
xlim_values = [-10, 215]
xticks_values = np.arange(25, 201, 25)

ylabel_value = "Average Fuel Efficiency (MPG)"
ylim_values = [18, 34]
yticks_values = np.arange(20, 34, 2)

# Labels
label_1 = "Model A"
label_2 = "Model B"
label_3 = "Baseline Model"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
fig, ax = plt.subplots(
    figsize=(6, 4)
)  # Adjusting figure size to match original image dimensions

# Line charts
ax.plot(x, model_a_y, marker="s", color="#d62728", label=label_1)
ax.plot(
    x, model_b_y, marker="p", color="#1f77b4", label=label_2, markersize=8
)

# Set x,y-axis to only display specific ticks and extend y-axis to leave space at top
plt.yticks(yticks_values, fontsize=12)
plt.xticks(xticks_values, fontsize=12)
plt.xlim(xlim_values)

# Horizontal dashed line
ax.axhline(
    y=baseline_fuel_efficiency,
    color="green",
    linestyle="-.",
    label=label_3,
)

# Legend
ax.legend(loc="lower right")

# Labels
ax.set_xlabel(xlabel_value)
ax.set_ylabel(ylabel_value)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and show plot
plt.tight_layout()
plt.savefig('line_28.pdf', bbox_inches='tight')
