import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)

# ===================
# Part 2: Data Preparation
# ===================
# Placeholder data
vehicle_speed = np.arange(30, 70, 10)
sedan_efficiency = [35, 33, 30, 28]
suv_efficiency = [28, 25, 23, 20]
truck_efficiency = [20, 18, 15, 13]
ev_efficiency = [100, 90, 85, 80]

# Placeholder error values
sedan_error = np.array([2.1, 2.43, 2.21, 2.09])
suv_error = np.array([1.85, 2.29, 1.88, 2.78])
truck_error = np.array([2.93, 1.77, 2.58, 2.06])
ev_error = np.array([7.84, 9.63, 5.36, 5.44])

# Axes Limits and Labels
xlabel_value = "Vehicle Speed (MPH)"
ylabel_value = "Fuel Efficiency (MPG)"
ylim_values = [10, 110]
yticks_values = np.arange(10, 111, 10)

# Labels
label_sedan = "Sedan"
label_suv = "SUV"
label_truck = "Truck"
label_ev = "Electric Vehicle"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the data
plt.figure(figsize=(8, 6))  # Adjusting figure size to match original image dimensions
plt.errorbar(
    vehicle_speed,
    sedan_efficiency,
    yerr=sedan_error,
    fmt="-o",
    label=label_sedan,
    color="blue",
    linestyle="dashed",
)
plt.errorbar(
    vehicle_speed,
    suv_efficiency,
    yerr=suv_error,
    fmt="-s",
    label=label_suv,
    color="green",
    linestyle="dashed",
)
plt.errorbar(
    vehicle_speed,
    truck_efficiency,
    yerr=truck_error,
    fmt="-^",
    label=label_truck,
    color="orange",
    linestyle="dashed",
)
plt.errorbar(
    vehicle_speed,
    ev_efficiency,
    yerr=ev_error,
    fmt="-d",
    label=label_ev,
    color="red",
    linestyle="dashed",
)

# Adding labels and title
plt.xlabel(xlabel_value)
plt.ylabel(ylabel_value)
plt.xticks(vehicle_speed)
plt.ylim(ylim_values)
plt.yticks(yticks_values)

# Adding legend, lower left corner
plt.legend(loc="lower left")

# Moving axes spines
ax = plt.gca()  # get current axes
ax.spines["right"].set_color("none")  # hide the right spine
ax.spines["top"].set_color("none")  # hide the top spine
ax.grid(
    True, which="both", axis="both", color="lightgray", linestyle="--", linewidth=0.5
)

# ===================
# Part 4: Saving Output
# ===================
# Display the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig('line_31.pdf', bbox_inches='tight')
